/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class WeChatPayAccountPayload
extends PaymentAccountPayload {
    private String accountNr = "";

    public WeChatPayAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private WeChatPayAccountPayload(String paymentMethod, String id, String accountNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.accountNr = accountNr;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setWeChatPayAccountPayload(protobuf.WeChatPayAccountPayload.newBuilder().setAccountNr(this.accountNr)).build();
    }

    public static WeChatPayAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new WeChatPayAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getWeChatPayAccountPayload().getAccountNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.no") + " " + this.accountNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.accountNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeChatPayAccountPayload)) {
            return false;
        }
        WeChatPayAccountPayload other = (WeChatPayAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountNr = this.getAccountNr();
        String other$accountNr = other.getAccountNr();
        return !(this$accountNr == null ? other$accountNr != null : !this$accountNr.equals(other$accountNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WeChatPayAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountNr = this.getAccountNr();
        result = result * 59 + ($accountNr == null ? 43 : $accountNr.hashCode());
        return result;
    }

    public String getAccountNr() {
        return this.accountNr;
    }

    public void setAccountNr(String accountNr) {
        this.accountNr = accountNr;
    }

    @Override
    public String toString() {
        return "WeChatPayAccountPayload(accountNr=" + this.getAccountNr() + ")";
    }
}

