/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VerseAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(VerseAccountPayload.class);
    private String holderName = "";

    public VerseAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private VerseAccountPayload(String paymentMethod, String id, String holderName, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setVerseAccountPayload(protobuf.VerseAccountPayload.newBuilder().setHolderName(this.holderName)).build();
    }

    public static VerseAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new VerseAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getVerseAccountPayload().getHolderName(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.username") + " " + this.holderName;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.holderName.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerseAccountPayload)) {
            return false;
        }
        VerseAccountPayload other = (VerseAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        return !(this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VerseAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "VerseAccountPayload(holderName=" + this.getHolderName() + ")";
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getHolderName() {
        return this.holderName;
    }
}

