/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.TransferwiseUsdAccountPayload;

public final class TransferwiseUsdAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(TransferwiseUsdAccountPayload.class);
    private String email = "";
    private String holderName = "";
    private String holderAddress = "";

    public TransferwiseUsdAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private TransferwiseUsdAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String email, String holderName, String holderAddress, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.email = email;
        this.holderName = holderName;
        this.holderAddress = holderAddress;
    }

    public Message toProtoMessage() {
        TransferwiseUsdAccountPayload.Builder builder = protobuf.TransferwiseUsdAccountPayload.newBuilder().setEmail(this.email).setHolderName(this.holderName).setHolderAddress(this.holderAddress);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setTransferwiseUsdAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static TransferwiseUsdAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.TransferwiseUsdAccountPayload accountPayloadPB = countryBasedPaymentAccountPayload.getTransferwiseUsdAccountPayload();
        return new TransferwiseUsdAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), accountPayloadPB.getEmail(), accountPayloadPB.getHolderName(), accountPayloadPB.getHolderAddress(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.username") + " " + this.holderName;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.holderName.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferwiseUsdAccountPayload)) {
            return false;
        }
        TransferwiseUsdAccountPayload other = (TransferwiseUsdAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$holderAddress = this.getHolderAddress();
        String other$holderAddress = other.getHolderAddress();
        return !(this$holderAddress == null ? other$holderAddress != null : !this$holderAddress.equals(other$holderAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TransferwiseUsdAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $holderAddress = this.getHolderAddress();
        result = result * 59 + ($holderAddress == null ? 43 : $holderAddress.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TransferwiseUsdAccountPayload(email=" + this.getEmail() + ", holderName=" + this.getHolderName() + ", holderAddress=" + this.getHolderAddress() + ")";
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setHolderAddress(String holderAddress) {
        this.holderAddress = holderAddress;
    }

    public String getEmail() {
        return this.email;
    }

    public String getHolderName() {
        return this.holderName;
    }

    public String getHolderAddress() {
        return this.holderAddress;
    }
}

