/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwishAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(SwishAccountPayload.class);
    private String mobileNr = "";
    private String holderName = "";

    public SwishAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private SwishAccountPayload(String paymentMethod, String id, String mobileNr, String holderName, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.mobileNr = mobileNr;
        this.holderName = holderName;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setSwishAccountPayload(protobuf.SwishAccountPayload.newBuilder().setMobileNr(this.mobileNr).setHolderName(this.holderName)).build();
    }

    public static SwishAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new SwishAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getSwishAccountPayload().getMobileNr(), proto.getSwishAccountPayload().getHolderName(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.getWithCol("payment.mobile") + " " + this.mobileNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + Res.getWithCol("payment.mobile") + " " + this.mobileNr;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.mobileNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwishAccountPayload)) {
            return false;
        }
        SwishAccountPayload other = (SwishAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mobileNr = this.getMobileNr();
        String other$mobileNr = other.getMobileNr();
        if (this$mobileNr == null ? other$mobileNr != null : !this$mobileNr.equals(other$mobileNr)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        return !(this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SwishAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mobileNr = this.getMobileNr();
        result = result * 59 + ($mobileNr == null ? 43 : $mobileNr.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SwishAccountPayload(mobileNr=" + this.getMobileNr() + ", holderName=" + this.getHolderName() + ")";
    }

    public void setMobileNr(String mobileNr) {
        this.mobileNr = mobileNr;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getMobileNr() {
        return this.mobileNr;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }
}

