/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.StrikeAccountPayload;

public final class StrikeAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(StrikeAccountPayload.class);
    private String holderName = "";

    public StrikeAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private StrikeAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
    }

    public Message toProtoMessage() {
        StrikeAccountPayload.Builder builder = protobuf.StrikeAccountPayload.newBuilder().setHolderName(this.holderName);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setStrikeAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static StrikeAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.StrikeAccountPayload accountPayloadPB = countryBasedPaymentAccountPayload.getStrikeAccountPayload();
        return new StrikeAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), accountPayloadPB.getHolderName(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.username") + " " + this.holderName;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.holderName.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrikeAccountPayload)) {
            return false;
        }
        StrikeAccountPayload other = (StrikeAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        return !(this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StrikeAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StrikeAccountPayload(holderName=" + this.getHolderName() + ")";
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getHolderName() {
        return this.holderName;
    }
}

