/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.common.base.Joiner;
import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.BankAccountPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.BankAccountPayload;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.SpecificBanksAccountPayload;

public final class SpecificBanksAccountPayload
extends BankAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(SpecificBanksAccountPayload.class);
    private ArrayList<String> acceptedBanks = new ArrayList();

    public SpecificBanksAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private SpecificBanksAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String bankName, String branchId, String accountNr, String accountType, String holderTaxId, String bankId, String nationalAccountId, ArrayList<String> acceptedBanks, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, holderName, bankName, branchId, accountNr, accountType, holderTaxId, bankId, nationalAccountId, maxTradePeriod, excludeFromJsonDataMap);
        this.acceptedBanks = acceptedBanks;
    }

    public Message toProtoMessage() {
        SpecificBanksAccountPayload.Builder builder = protobuf.SpecificBanksAccountPayload.newBuilder().addAllAcceptedBanks(this.acceptedBanks);
        BankAccountPayload.Builder bankAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().getBankAccountPayloadBuilder().setSpecificBanksAccountPayload(builder);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setBankAccountPayload(bankAccountPayloadBuilder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder).build();
    }

    public static SpecificBanksAccountPayload fromProto(PaymentAccountPayload proto) {
        CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.BankAccountPayload bankAccountPayload = countryBasedPaymentAccountPayload.getBankAccountPayload();
        protobuf.SpecificBanksAccountPayload specificBanksAccountPayload = bankAccountPayload.getSpecificBanksAccountPayload();
        return new SpecificBanksAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), bankAccountPayload.getHolderName(), bankAccountPayload.getBankName().isEmpty() ? null : bankAccountPayload.getBankName(), bankAccountPayload.getBranchId().isEmpty() ? null : bankAccountPayload.getBranchId(), bankAccountPayload.getAccountNr().isEmpty() ? null : bankAccountPayload.getAccountNr(), bankAccountPayload.getAccountType().isEmpty() ? null : bankAccountPayload.getAccountType(), bankAccountPayload.getHolderTaxId().isEmpty() ? null : bankAccountPayload.getHolderTaxId(), bankAccountPayload.getBankId().isEmpty() ? null : bankAccountPayload.getBankId(), bankAccountPayload.getNationalAccountId().isEmpty() ? null : bankAccountPayload.getNationalAccountId(), new ArrayList<String>((Collection<String>)specificBanksAccountPayload.getAcceptedBanksList()), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    public void clearAcceptedBanks() {
        this.acceptedBanks = new ArrayList();
    }

    public void addAcceptedBank(String bankName) {
        if (!this.acceptedBanks.contains(bankName)) {
            this.acceptedBanks.add(bankName);
        }
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return super.getPaymentDetailsForTradePopup() + "\n" + Res.getWithCol("payment.accepted.banks") + " " + Joiner.on((String)", ").join(this.acceptedBanks);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecificBanksAccountPayload)) {
            return false;
        }
        SpecificBanksAccountPayload other = (SpecificBanksAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayList<String> this$acceptedBanks = this.getAcceptedBanks();
        ArrayList<String> other$acceptedBanks = other.getAcceptedBanks();
        return !(this$acceptedBanks == null ? other$acceptedBanks != null : !((Object)this$acceptedBanks).equals(other$acceptedBanks));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpecificBanksAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ArrayList<String> $acceptedBanks = this.getAcceptedBanks();
        result = result * 59 + ($acceptedBanks == null ? 43 : ((Object)$acceptedBanks).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SpecificBanksAccountPayload(acceptedBanks=" + String.valueOf(this.getAcceptedBanks()) + ")";
    }

    public ArrayList<String> getAcceptedBanks() {
        return this.acceptedBanks;
    }
}

