/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.BankAccountPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.BankAccountPayload;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;

public final class SameBankAccountPayload
extends BankAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(SameBankAccountPayload.class);

    public SameBankAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private SameBankAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String bankName, String branchId, String accountNr, String accountType, String holderTaxId, String bankId, String nationalAccountId, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, holderName, bankName, branchId, accountNr, accountType, holderTaxId, bankId, nationalAccountId, maxTradePeriod, excludeFromJsonDataMap);
    }

    public Message toProtoMessage() {
        BankAccountPayload.Builder bankAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().getBankAccountPayloadBuilder().setSameBankAccontPayload(protobuf.SameBankAccountPayload.newBuilder());
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setBankAccountPayload(bankAccountPayloadBuilder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder).build();
    }

    public static SameBankAccountPayload fromProto(PaymentAccountPayload proto) {
        CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.BankAccountPayload bankAccountPayload = countryBasedPaymentAccountPayload.getBankAccountPayload();
        return new SameBankAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), bankAccountPayload.getHolderName(), bankAccountPayload.getBankName().isEmpty() ? null : bankAccountPayload.getBankName(), bankAccountPayload.getBranchId().isEmpty() ? null : bankAccountPayload.getBranchId(), bankAccountPayload.getAccountNr().isEmpty() ? null : bankAccountPayload.getAccountNr(), bankAccountPayload.getAccountType().isEmpty() ? null : bankAccountPayload.getAccountType(), bankAccountPayload.getHolderTaxId().isEmpty() ? null : bankAccountPayload.getHolderTaxId(), bankAccountPayload.getBankId().isEmpty() ? null : bankAccountPayload.getBankId(), bankAccountPayload.getNationalAccountId().isEmpty() ? null : bankAccountPayload.getNationalAccountId(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SameBankAccountPayload)) {
            return false;
        }
        SameBankAccountPayload other = (SameBankAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SameBankAccountPayload;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SameBankAccountPayload()";
    }
}

