/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import haveno.common.util.JsonExclude;
import haveno.common.util.Tuple2;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.RevolutAccountPayload;

public final class RevolutAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(RevolutAccountPayload.class);
    @JsonExclude
    private String username = "";

    public RevolutAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private RevolutAccountPayload(String paymentMethod, String id, @Nullable String username, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.username = username;
    }

    public Message toProtoMessage() {
        RevolutAccountPayload.Builder revolutBuilder = protobuf.RevolutAccountPayload.newBuilder().setUsername(this.username);
        return this.getPaymentAccountPayloadBuilder().setRevolutAccountPayload(revolutBuilder).build();
    }

    public static RevolutAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.RevolutAccountPayload revolutAccountPayload = proto.getRevolutAccountPayload();
        return new RevolutAccountPayload(proto.getPaymentMethodId(), proto.getId(), revolutAccountPayload.getUsername(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        Tuple2<String, String> tuple = this.getLabelValueTuple();
        return Res.get(this.paymentMethodId) + " - " + (String)tuple.first + ": " + (String)tuple.second;
    }

    private Tuple2<String, String> getLabelValueTuple() {
        Preconditions.checkArgument((!this.username.isEmpty() ? 1 : 0) != 0, (Object)"Username must be set");
        String label = Res.get("payment.account.username");
        String value = this.username;
        return new Tuple2((Object)label, (Object)value);
    }

    public Tuple2<String, String> getRecipientsAccountData() {
        Tuple2<String, String> tuple = this.getLabelValueTuple();
        String label = Res.get("portfolio.pending.step2_buyer.recipientsAccountData", tuple.first);
        return new Tuple2((Object)label, (Object)((String)tuple.second));
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.username.getBytes(StandardCharsets.UTF_8));
    }

    public boolean usernameNotSet() {
        return this.username.isEmpty();
    }

    public void setUserName(String username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolutAccountPayload)) {
            return false;
        }
        RevolutAccountPayload other = (RevolutAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolutAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RevolutAccountPayload(username=" + this.getUsername() + ")";
    }

    public String getUsername() {
        return this.username;
    }
}

