/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PromptPayAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(PromptPayAccountPayload.class);
    private String promptPayId = "";

    public PromptPayAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private PromptPayAccountPayload(String paymentMethod, String id, String promptPayId, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.promptPayId = promptPayId;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setPromptPayAccountPayload(protobuf.PromptPayAccountPayload.newBuilder().setPromptPayId(this.promptPayId)).build();
    }

    public static PromptPayAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new PromptPayAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getPromptPayAccountPayload().getPromptPayId(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.getWithCol("payment.promptPay.promptPayId") + " " + this.promptPayId;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.promptPayId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromptPayAccountPayload)) {
            return false;
        }
        PromptPayAccountPayload other = (PromptPayAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$promptPayId = this.getPromptPayId();
        String other$promptPayId = other.getPromptPayId();
        return !(this$promptPayId == null ? other$promptPayId != null : !this$promptPayId.equals(other$promptPayId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PromptPayAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $promptPayId = this.getPromptPayId();
        result = result * 59 + ($promptPayId == null ? 43 : $promptPayId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PromptPayAccountPayload(promptPayId=" + this.getPromptPayId() + ")";
    }

    public void setPromptPayId(String promptPayId) {
        this.promptPayId = promptPayId;
    }

    public String getPromptPayId() {
        return this.promptPayId;
    }
}

