/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PopmoneyAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(PopmoneyAccountPayload.class);
    private String accountId = "";
    private String holderName = "";

    public PopmoneyAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private PopmoneyAccountPayload(String paymentMethod, String id, String accountId, String holderName, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.accountId = accountId;
        this.holderName = holderName;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setPopmoneyAccountPayload(protobuf.PopmoneyAccountPayload.newBuilder().setAccountId(this.accountId).setHolderName(this.holderName)).build();
    }

    public static PopmoneyAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new PopmoneyAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getPopmoneyAccountPayload().getAccountId(), proto.getPopmoneyAccountPayload().getHolderName(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.getWithCol("payment.popmoney.accountId") + " " + this.accountId;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.accountId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopmoneyAccountPayload)) {
            return false;
        }
        PopmoneyAccountPayload other = (PopmoneyAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        return !(this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PopmoneyAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PopmoneyAccountPayload(accountId=" + this.getAccountId() + ", holderName=" + this.getHolderName() + ")";
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }
}

