/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;
import protobuf.PaytmAccountPayload;

public final class PaytmAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(PaytmAccountPayload.class);
    private String emailOrMobileNr = "";

    public PaytmAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private PaytmAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String emailOrMobileNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNr = emailOrMobileNr;
    }

    public Message toProtoMessage() {
        PaytmAccountPayload.Builder builder = protobuf.PaytmAccountPayload.newBuilder().setEmailOrMobileNr(this.emailOrMobileNr);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setPaytmAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static PaytmAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.PaytmAccountPayload paytmAccountPayloadPB = countryBasedPaymentAccountPayload.getPaytmAccountPayload();
        return new PaytmAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), paytmAccountPayloadPB.getEmailOrMobileNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.email.mobile") + " " + this.emailOrMobileNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.emailOrMobileNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaytmAccountPayload)) {
            return false;
        }
        PaytmAccountPayload other = (PaytmAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNr = this.getEmailOrMobileNr();
        String other$emailOrMobileNr = other.getEmailOrMobileNr();
        return !(this$emailOrMobileNr == null ? other$emailOrMobileNr != null : !this$emailOrMobileNr.equals(other$emailOrMobileNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaytmAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNr = this.getEmailOrMobileNr();
        result = result * 59 + ($emailOrMobileNr == null ? 43 : $emailOrMobileNr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PaytmAccountPayload(emailOrMobileNr=" + this.getEmailOrMobileNr() + ")";
    }

    public void setEmailOrMobileNr(String emailOrMobileNr) {
        this.emailOrMobileNr = emailOrMobileNr;
    }

    public String getEmailOrMobileNr() {
        return this.emailOrMobileNr;
    }
}

