/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.AchTransferAccount;
import haveno.core.payment.AdvancedCashAccount;
import haveno.core.payment.AliPayAccount;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.AustraliaPayidAccount;
import haveno.core.payment.BizumAccount;
import haveno.core.payment.CapitualAccount;
import haveno.core.payment.CashAppAccount;
import haveno.core.payment.CashAtAtmAccount;
import haveno.core.payment.CashDepositAccount;
import haveno.core.payment.CelPayAccount;
import haveno.core.payment.DomesticWireTransferAccount;
import haveno.core.payment.F2FAccount;
import haveno.core.payment.FasterPaymentsAccount;
import haveno.core.payment.HalCashAccount;
import haveno.core.payment.ImpsAccount;
import haveno.core.payment.InteracETransferAccount;
import haveno.core.payment.JapanBankAccount;
import haveno.core.payment.MoneseAccount;
import haveno.core.payment.MoneyBeamAccount;
import haveno.core.payment.MoneyGramAccount;
import haveno.core.payment.NationalBankAccount;
import haveno.core.payment.NeftAccount;
import haveno.core.payment.NequiAccount;
import haveno.core.payment.PaxumAccount;
import haveno.core.payment.PayByMailAccount;
import haveno.core.payment.PayPalAccount;
import haveno.core.payment.PaysafeAccount;
import haveno.core.payment.PayseraAccount;
import haveno.core.payment.PaytmAccount;
import haveno.core.payment.PerfectMoneyAccount;
import haveno.core.payment.PixAccount;
import haveno.core.payment.PopmoneyAccount;
import haveno.core.payment.PromptPayAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.RtgsAccount;
import haveno.core.payment.SameBankAccount;
import haveno.core.payment.SatispayAccount;
import haveno.core.payment.SepaAccount;
import haveno.core.payment.SepaInstantAccount;
import haveno.core.payment.SpecificBanksAccount;
import haveno.core.payment.StrikeAccount;
import haveno.core.payment.SwiftAccount;
import haveno.core.payment.SwishAccount;
import haveno.core.payment.TikkieAccount;
import haveno.core.payment.TradeLimits;
import haveno.core.payment.TransferwiseAccount;
import haveno.core.payment.TransferwiseUsdAccount;
import haveno.core.payment.USPostalMoneyOrderAccount;
import haveno.core.payment.UpholdAccount;
import haveno.core.payment.UpiAccount;
import haveno.core.payment.VenmoAccount;
import haveno.core.payment.VerseAccount;
import haveno.core.payment.WeChatPayAccount;
import haveno.core.payment.WesternUnionAccount;
import haveno.core.payment.ZelleAccount;
import haveno.core.trade.HavenoUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaymentMethod
implements PersistablePayload,
Comparable<PaymentMethod> {
    private static final Logger log = LoggerFactory.getLogger(PaymentMethod.class);
    private static final long DAY = Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_LOCAL ? TimeUnit.MINUTES.toMillis(1L) : (Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_STAGENET ? TimeUnit.MINUTES.toMillis(30L) : TimeUnit.DAYS.toMillis(1L));
    private static final BigInteger DEFAULT_TRADE_LIMIT_CRYPTO = HavenoUtils.xmrToAtomicUnits(200.0);
    private static final BigInteger DEFAULT_TRADE_LIMIT_VERY_LOW_RISK = HavenoUtils.xmrToAtomicUnits(100.0);
    private static final BigInteger DEFAULT_TRADE_LIMIT_LOW_RISK = HavenoUtils.xmrToAtomicUnits(50.0);
    private static final BigInteger DEFAULT_TRADE_LIMIT_MID_RISK = HavenoUtils.xmrToAtomicUnits(25.0);
    private static final BigInteger DEFAULT_TRADE_LIMIT_HIGH_RISK = HavenoUtils.xmrToAtomicUnits(12.5);
    public static final String UPHOLD_ID = "UPHOLD";
    public static final String MONEY_BEAM_ID = "MONEY_BEAM";
    public static final String POPMONEY_ID = "POPMONEY";
    public static final String REVOLUT_ID = "REVOLUT";
    public static final String PERFECT_MONEY_ID = "PERFECT_MONEY";
    public static final String SEPA_ID = "SEPA";
    public static final String SEPA_INSTANT_ID = "SEPA_INSTANT";
    public static final String FASTER_PAYMENTS_ID = "FASTER_PAYMENTS";
    public static final String NATIONAL_BANK_ID = "NATIONAL_BANK";
    public static final String JAPAN_BANK_ID = "JAPAN_BANK";
    public static final String AUSTRALIA_PAYID_ID = "AUSTRALIA_PAYID";
    public static final String SAME_BANK_ID = "SAME_BANK";
    public static final String SPECIFIC_BANKS_ID = "SPECIFIC_BANKS";
    public static final String SWISH_ID = "SWISH";
    public static final String ALI_PAY_ID = "ALI_PAY";
    public static final String WECHAT_PAY_ID = "WECHAT_PAY";
    public static final String ZELLE_ID = "ZELLE";
    @Deprecated
    public static final String CHASE_QUICK_PAY_ID = "CHASE_QUICK_PAY";
    public static final String INTERAC_E_TRANSFER_ID = "INTERAC_E_TRANSFER";
    public static final String US_POSTAL_MONEY_ORDER_ID = "US_POSTAL_MONEY_ORDER";
    public static final String CASH_DEPOSIT_ID = "CASH_DEPOSIT";
    public static final String MONEY_GRAM_ID = "MONEY_GRAM";
    public static final String WESTERN_UNION_ID = "WESTERN_UNION";
    public static final String HAL_CASH_ID = "HAL_CASH";
    public static final String F2F_ID = "F2F";
    public static final String BLOCK_CHAINS_ID = "BLOCK_CHAINS";
    public static final String PROMPT_PAY_ID = "PROMPT_PAY";
    public static final String ADVANCED_CASH_ID = "ADVANCED_CASH";
    public static final String TRANSFERWISE_ID = "TRANSFERWISE";
    public static final String TRANSFERWISE_USD_ID = "TRANSFERWISE_USD";
    public static final String PAYSERA_ID = "PAYSERA";
    public static final String PAXUM_ID = "PAXUM";
    public static final String NEFT_ID = "NEFT";
    public static final String RTGS_ID = "RTGS";
    public static final String IMPS_ID = "IMPS";
    public static final String UPI_ID = "UPI";
    public static final String PAYTM_ID = "PAYTM";
    public static final String NEQUI_ID = "NEQUI";
    public static final String BIZUM_ID = "BIZUM";
    public static final String PIX_ID = "PIX";
    public static final String AMAZON_GIFT_CARD_ID = "AMAZON_GIFT_CARD";
    public static final String BLOCK_CHAINS_INSTANT_ID = "BLOCK_CHAINS_INSTANT";
    public static final String PAY_BY_MAIL_ID = "PAY_BY_MAIL";
    public static final String CASH_AT_ATM_ID = "CASH_AT_ATM";
    public static final String CAPITUAL_ID = "CAPITUAL";
    public static final String CELPAY_ID = "CELPAY";
    public static final String MONESE_ID = "MONESE";
    public static final String SATISPAY_ID = "SATISPAY";
    public static final String TIKKIE_ID = "TIKKIE";
    public static final String VERSE_ID = "VERSE";
    public static final String STRIKE_ID = "STRIKE";
    public static final String SWIFT_ID = "SWIFT";
    public static final String ACH_TRANSFER_ID = "ACH_TRANSFER";
    public static final String DOMESTIC_WIRE_TRANSFER_ID = "DOMESTIC_WIRE_TRANSFER";
    @Deprecated
    public static final String OK_PAY_ID = "OK_PAY";
    public static final String CASH_APP_ID = "CASH_APP";
    public static final String VENMO_ID = "VENMO";
    public static final String PAYPAL_ID = "PAYPAL";
    public static final String PAYSAFE_ID = "PAYSAFE";
    public static PaymentMethod UPHOLD;
    public static PaymentMethod MONEY_BEAM;
    public static PaymentMethod POPMONEY;
    public static PaymentMethod REVOLUT;
    public static PaymentMethod PERFECT_MONEY;
    public static PaymentMethod SEPA;
    public static PaymentMethod SEPA_INSTANT;
    public static PaymentMethod FASTER_PAYMENTS;
    public static PaymentMethod NATIONAL_BANK;
    public static PaymentMethod JAPAN_BANK;
    public static PaymentMethod AUSTRALIA_PAYID;
    public static PaymentMethod SAME_BANK;
    public static PaymentMethod SPECIFIC_BANKS;
    public static PaymentMethod SWISH;
    public static PaymentMethod ALI_PAY;
    public static PaymentMethod WECHAT_PAY;
    public static PaymentMethod ZELLE;
    public static PaymentMethod CHASE_QUICK_PAY;
    public static PaymentMethod INTERAC_E_TRANSFER;
    public static PaymentMethod US_POSTAL_MONEY_ORDER;
    public static PaymentMethod CASH_DEPOSIT;
    public static PaymentMethod MONEY_GRAM;
    public static PaymentMethod WESTERN_UNION;
    public static PaymentMethod F2F;
    public static PaymentMethod HAL_CASH;
    public static PaymentMethod BLOCK_CHAINS;
    public static PaymentMethod PROMPT_PAY;
    public static PaymentMethod ADVANCED_CASH;
    public static PaymentMethod TRANSFERWISE;
    public static PaymentMethod TRANSFERWISE_USD;
    public static PaymentMethod PAYSERA;
    public static PaymentMethod PAXUM;
    public static PaymentMethod NEFT;
    public static PaymentMethod RTGS;
    public static PaymentMethod IMPS;
    public static PaymentMethod UPI;
    public static PaymentMethod PAYTM;
    public static PaymentMethod NEQUI;
    public static PaymentMethod BIZUM;
    public static PaymentMethod PIX;
    public static PaymentMethod AMAZON_GIFT_CARD;
    public static PaymentMethod BLOCK_CHAINS_INSTANT;
    public static PaymentMethod PAY_BY_MAIL;
    public static PaymentMethod CASH_AT_ATM;
    public static PaymentMethod CAPITUAL;
    public static PaymentMethod CELPAY;
    public static PaymentMethod MONESE;
    public static PaymentMethod SATISPAY;
    public static PaymentMethod TIKKIE;
    public static PaymentMethod VERSE;
    public static PaymentMethod STRIKE;
    public static PaymentMethod SWIFT;
    public static PaymentMethod ACH_TRANSFER;
    public static PaymentMethod DOMESTIC_WIRE_TRANSFER;
    public static PaymentMethod BSQ_SWAP;
    public static PaymentMethod PAYPAL;
    public static PaymentMethod CASH_APP;
    public static PaymentMethod VENMO;
    public static PaymentMethod PAYSAFE;
    @Deprecated
    public static PaymentMethod OK_PAY;
    public static final List<PaymentMethod> paymentMethods;
    private final String id;
    private final long maxTradePeriod;
    private final long maxTradeLimit;
    private List<String> supportedAssetCodes;

    public static List<PaymentMethod> getPaymentMethods() {
        List<String> paymentMethodIds = List.of(BLOCK_CHAINS_ID, CASH_AT_ATM_ID, FASTER_PAYMENTS_ID, F2F_ID, MONEY_GRAM_ID, PAXUM_ID, PAY_BY_MAIL_ID, REVOLUT_ID, SEPA_ID, SEPA_INSTANT_ID, STRIKE_ID, SWIFT_ID, TRANSFERWISE_ID, UPHOLD_ID, ZELLE_ID, AUSTRALIA_PAYID_ID, CASH_APP_ID, PAYPAL_ID, VENMO_ID, PAYSAFE_ID, WECHAT_PAY_ID, ALI_PAY_ID, SWISH_ID, TRANSFERWISE_USD_ID, AMAZON_GIFT_CARD_ID, ACH_TRANSFER_ID, INTERAC_E_TRANSFER_ID, US_POSTAL_MONEY_ORDER_ID);
        return paymentMethods.stream().filter(paymentMethod -> paymentMethodIds.contains(paymentMethod.getId())).collect(Collectors.toList());
    }

    private static List<String> getAssetCodes(List<TradeCurrency> tradeCurrencies) {
        return tradeCurrencies.stream().map(TradeCurrency::getCode).collect(Collectors.toList());
    }

    public static PaymentMethod getDummyPaymentMethod(String id) {
        return new PaymentMethod(id, 0L, BigInteger.ZERO, Arrays.asList(new String[0]));
    }

    private PaymentMethod(String id, long maxTradePeriod, BigInteger maxTradeLimit, List<String> supportedAssetCodes) {
        this.id = id;
        this.maxTradePeriod = maxTradePeriod;
        this.maxTradeLimit = maxTradeLimit.longValueExact();
        this.supportedAssetCodes = supportedAssetCodes;
    }

    private PaymentMethod(String id) {
        this(id, 0L, BigInteger.ZERO, new ArrayList<String>());
    }

    public protobuf.PaymentMethod toProtoMessage() {
        return protobuf.PaymentMethod.newBuilder().setId(this.id).setMaxTradePeriod(this.maxTradePeriod).setMaxTradeLimit(this.maxTradeLimit).addAllSupportedAssetCodes(this.supportedAssetCodes).build();
    }

    public static PaymentMethod fromProto(protobuf.PaymentMethod proto) {
        return new PaymentMethod(proto.getId(), proto.getMaxTradePeriod(), BigInteger.valueOf(proto.getMaxTradeLimit()), (List<String>)proto.getSupportedAssetCodesList());
    }

    public static PaymentMethod getPaymentMethod(String id) {
        return PaymentMethod.getActivePaymentMethod(id).orElseThrow(() -> new IllegalArgumentException("Invalid payment method id: " + id));
    }

    public static PaymentMethod getPaymentMethodOrNA(String id) {
        return PaymentMethod.getActivePaymentMethod(id).orElseGet(() -> new PaymentMethod(Res.get("shared.na")));
    }

    public static Optional<PaymentMethod> getActivePaymentMethod(String id) {
        return paymentMethods.stream().filter(e -> e.getId().equals(id)).findFirst();
    }

    public BigInteger getMaxTradeLimit(String currencyCode) {
        long riskFactor;
        if (currencyCode.equals("SF")) {
            return HavenoUtils.xmrToAtomicUnits(4.0);
        }
        if (this.id.equals(NEFT_ID) || this.id.equals(UPI_ID) || this.id.equals(PAYTM_ID) || this.id.equals(BIZUM_ID) || this.id.equals(TIKKIE_ID)) {
            return BigInteger.valueOf(this.maxTradeLimit);
        }
        if (this.maxTradeLimit == DEFAULT_TRADE_LIMIT_CRYPTO.longValueExact()) {
            riskFactor = 1L;
        } else if (this.maxTradeLimit == DEFAULT_TRADE_LIMIT_VERY_LOW_RISK.longValueExact()) {
            riskFactor = 4L;
        } else if (this.maxTradeLimit == DEFAULT_TRADE_LIMIT_LOW_RISK.longValueExact()) {
            riskFactor = 11L;
        } else if (this.maxTradeLimit == DEFAULT_TRADE_LIMIT_MID_RISK.longValueExact()) {
            riskFactor = 22L;
        } else if (this.maxTradeLimit == DEFAULT_TRADE_LIMIT_HIGH_RISK.longValueExact()) {
            riskFactor = 44L;
        } else {
            riskFactor = 44L;
            log.warn("maxTradeLimit is not matching one of our default values. We use highest risk factor. maxTradeLimit={}. PaymentMethod={}", (Object)this.maxTradeLimit, (Object)this);
        }
        TradeLimits tradeLimits = new TradeLimits();
        long maxTradeLimit = tradeLimits.getMaxTradeLimit().longValueExact();
        long riskBasedTradeLimit = tradeLimits.getRoundedRiskBasedTradeLimit(maxTradeLimit, riskFactor);
        return BigInteger.valueOf(riskBasedTradeLimit);
    }

    public String getShortName() {
        return Res.get(this.id + "_SHORT");
    }

    @Override
    public int compareTo(@NotNull PaymentMethod other) {
        return Res.get(this.id).compareTo(Res.get(other.id));
    }

    public String getDisplayString() {
        return Res.get(this.id);
    }

    public boolean isTraditional() {
        return !this.isCrypto();
    }

    public boolean isBlockchain() {
        return this.equals(BLOCK_CHAINS_INSTANT) || this.equals(BLOCK_CHAINS);
    }

    public boolean isCrypto() {
        return this.isBlockchain() || this.isBsqSwap();
    }

    public boolean isBsqSwap() {
        return this.equals(BSQ_SWAP);
    }

    public static boolean hasChargebackRisk(PaymentMethod paymentMethod, List<TradeCurrency> tradeCurrencies) {
        return tradeCurrencies.stream().anyMatch(tradeCurrency -> PaymentMethod.hasChargebackRisk(paymentMethod, tradeCurrency.getCode()));
    }

    public static boolean hasChargebackRisk(PaymentMethod paymentMethod) {
        return PaymentMethod.hasChargebackRisk(paymentMethod, CurrencyUtil.getMatureMarketCurrencies());
    }

    public static boolean hasChargebackRisk(PaymentMethod paymentMethod, String currencyCode) {
        if (paymentMethod == null) {
            return false;
        }
        String id = paymentMethod.getId();
        return PaymentMethod.hasChargebackRisk(id, currencyCode);
    }

    public static boolean hasChargebackRisk(String id, String currencyCode) {
        return id.equals(SEPA_ID) || id.equals(SEPA_INSTANT_ID) || id.equals(INTERAC_E_TRANSFER_ID) || id.equals(ZELLE_ID) || id.equals(REVOLUT_ID) || id.equals(NATIONAL_BANK_ID) || id.equals(SAME_BANK_ID) || id.equals(SPECIFIC_BANKS_ID) || id.equals(CHASE_QUICK_PAY_ID) || id.equals(POPMONEY_ID) || id.equals(MONEY_BEAM_ID) || id.equals(UPHOLD_ID) || id.equals(CASH_APP_ID) || id.equals(PAYPAL_ID) || id.equals(VENMO_ID) || id.equals(PAYSAFE_ID);
    }

    public static boolean isRoundedForAtmCash(String id) {
        return id.equals(CASH_AT_ATM_ID) || id.equals(HAL_CASH_ID);
    }

    public static boolean isFixedPriceOnly(String id) {
        return id.equals(HAL_CASH_ID);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMethod)) {
            return false;
        }
        PaymentMethod other = (PaymentMethod)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$supportedAssetCodes = this.getSupportedAssetCodes();
        List<String> other$supportedAssetCodes = other.getSupportedAssetCodes();
        return !(this$supportedAssetCodes == null ? other$supportedAssetCodes != null : !((Object)this$supportedAssetCodes).equals(other$supportedAssetCodes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $supportedAssetCodes = this.getSupportedAssetCodes();
        result = result * 59 + ($supportedAssetCodes == null ? 43 : ((Object)$supportedAssetCodes).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentMethod(id=" + this.getId() + ", maxTradePeriod=" + this.getMaxTradePeriod() + ", maxTradeLimit=" + this.maxTradeLimit + ", supportedAssetCodes=" + String.valueOf(this.getSupportedAssetCodes()) + ")";
    }

    public String getId() {
        return this.id;
    }

    public long getMaxTradePeriod() {
        return this.maxTradePeriod;
    }

    public List<String> getSupportedAssetCodes() {
        return this.supportedAssetCodes;
    }

    static {
        OK_PAY = PaymentMethod.getDummyPaymentMethod(OK_PAY_ID);
        HAL_CASH = new PaymentMethod(HAL_CASH_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(HalCashAccount.SUPPORTED_CURRENCIES));
        paymentMethods = Arrays.asList(HAL_CASH, SEPA = new PaymentMethod(SEPA_ID, 6L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(SepaAccount.SUPPORTED_CURRENCIES)), SEPA_INSTANT = new PaymentMethod(SEPA_INSTANT_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(SepaInstantAccount.SUPPORTED_CURRENCIES)), MONEY_BEAM = new PaymentMethod(MONEY_BEAM_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(MoneyBeamAccount.SUPPORTED_CURRENCIES)), FASTER_PAYMENTS = new PaymentMethod(FASTER_PAYMENTS_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(FasterPaymentsAccount.SUPPORTED_CURRENCIES)), SWISH = new PaymentMethod(SWISH_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(SwishAccount.SUPPORTED_CURRENCIES)), ZELLE = new PaymentMethod(ZELLE_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(ZelleAccount.SUPPORTED_CURRENCIES)), POPMONEY = new PaymentMethod(POPMONEY_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PopmoneyAccount.SUPPORTED_CURRENCIES)), US_POSTAL_MONEY_ORDER = new PaymentMethod(US_POSTAL_MONEY_ORDER_ID, 8L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(USPostalMoneyOrderAccount.SUPPORTED_CURRENCIES)), VENMO = new PaymentMethod(VENMO_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(VenmoAccount.SUPPORTED_CURRENCIES)), INTERAC_E_TRANSFER = new PaymentMethod(INTERAC_E_TRANSFER_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(InteracETransferAccount.SUPPORTED_CURRENCIES)), CASH_DEPOSIT = new PaymentMethod(CASH_DEPOSIT_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(CashDepositAccount.SUPPORTED_CURRENCIES)), PAY_BY_MAIL = new PaymentMethod(PAY_BY_MAIL_ID, 8L * DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(PayByMailAccount.SUPPORTED_CURRENCIES)), CASH_AT_ATM = new PaymentMethod(CASH_AT_ATM_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(CashAtAtmAccount.SUPPORTED_CURRENCIES)), MONEY_GRAM = new PaymentMethod(MONEY_GRAM_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_MID_RISK, PaymentMethod.getAssetCodes(MoneyGramAccount.SUPPORTED_CURRENCIES)), WESTERN_UNION = new PaymentMethod(WESTERN_UNION_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_MID_RISK, PaymentMethod.getAssetCodes(WesternUnionAccount.SUPPORTED_CURRENCIES)), NATIONAL_BANK = new PaymentMethod(NATIONAL_BANK_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(NationalBankAccount.SUPPORTED_CURRENCIES)), SAME_BANK = new PaymentMethod(SAME_BANK_ID, 2L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(SameBankAccount.SUPPORTED_CURRENCIES)), SPECIFIC_BANKS = new PaymentMethod(SPECIFIC_BANKS_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(SpecificBanksAccount.SUPPORTED_CURRENCIES)), F2F = new PaymentMethod(F2F_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(F2FAccount.SUPPORTED_CURRENCIES)), AMAZON_GIFT_CARD = new PaymentMethod(AMAZON_GIFT_CARD_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(AmazonGiftCardAccount.SUPPORTED_CURRENCIES)), UPHOLD = new PaymentMethod(UPHOLD_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(UpholdAccount.SUPPORTED_CURRENCIES)), REVOLUT = new PaymentMethod(REVOLUT_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(RevolutAccount.SUPPORTED_CURRENCIES)), PERFECT_MONEY = new PaymentMethod(PERFECT_MONEY_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(PerfectMoneyAccount.SUPPORTED_CURRENCIES)), ADVANCED_CASH = new PaymentMethod(ADVANCED_CASH_ID, DAY, DEFAULT_TRADE_LIMIT_VERY_LOW_RISK, PaymentMethod.getAssetCodes(AdvancedCashAccount.SUPPORTED_CURRENCIES)), TRANSFERWISE = new PaymentMethod(TRANSFERWISE_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(TransferwiseAccount.SUPPORTED_CURRENCIES)), TRANSFERWISE_USD = new PaymentMethod(TRANSFERWISE_USD_ID, 4L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(TransferwiseUsdAccount.SUPPORTED_CURRENCIES)), PAYSERA = new PaymentMethod(PAYSERA_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PayseraAccount.SUPPORTED_CURRENCIES)), PAXUM = new PaymentMethod(PAXUM_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PaxumAccount.SUPPORTED_CURRENCIES)), NEFT = new PaymentMethod(NEFT_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(NeftAccount.SUPPORTED_CURRENCIES)), RTGS = new PaymentMethod(RTGS_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(RtgsAccount.SUPPORTED_CURRENCIES)), IMPS = new PaymentMethod(IMPS_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(ImpsAccount.SUPPORTED_CURRENCIES)), UPI = new PaymentMethod(UPI_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(UpiAccount.SUPPORTED_CURRENCIES)), PAYTM = new PaymentMethod(PAYTM_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PaytmAccount.SUPPORTED_CURRENCIES)), NEQUI = new PaymentMethod(NEQUI_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(NequiAccount.SUPPORTED_CURRENCIES)), BIZUM = new PaymentMethod(BIZUM_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(BizumAccount.SUPPORTED_CURRENCIES)), PIX = new PaymentMethod(PIX_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PixAccount.SUPPORTED_CURRENCIES)), CAPITUAL = new PaymentMethod(CAPITUAL_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(CapitualAccount.SUPPORTED_CURRENCIES)), CELPAY = new PaymentMethod(CELPAY_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(CelPayAccount.SUPPORTED_CURRENCIES)), MONESE = new PaymentMethod(MONESE_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(MoneseAccount.SUPPORTED_CURRENCIES)), SATISPAY = new PaymentMethod(SATISPAY_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(SatispayAccount.SUPPORTED_CURRENCIES)), TIKKIE = new PaymentMethod(TIKKIE_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(TikkieAccount.SUPPORTED_CURRENCIES)), VERSE = new PaymentMethod(VERSE_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(VerseAccount.SUPPORTED_CURRENCIES)), STRIKE = new PaymentMethod(STRIKE_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(StrikeAccount.SUPPORTED_CURRENCIES)), SWIFT = new PaymentMethod(SWIFT_ID, 7L * DAY, DEFAULT_TRADE_LIMIT_MID_RISK, PaymentMethod.getAssetCodes(SwiftAccount.SUPPORTED_CURRENCIES)), ACH_TRANSFER = new PaymentMethod(ACH_TRANSFER_ID, 5L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(AchTransferAccount.SUPPORTED_CURRENCIES)), DOMESTIC_WIRE_TRANSFER = new PaymentMethod(DOMESTIC_WIRE_TRANSFER_ID, 3L * DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(DomesticWireTransferAccount.SUPPORTED_CURRENCIES)), PAYPAL = new PaymentMethod(PAYPAL_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PayPalAccount.SUPPORTED_CURRENCIES)), CASH_APP = new PaymentMethod(CASH_APP_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(CashAppAccount.SUPPORTED_CURRENCIES)), PAYSAFE = new PaymentMethod(PAYSAFE_ID, DAY, DEFAULT_TRADE_LIMIT_HIGH_RISK, PaymentMethod.getAssetCodes(PaysafeAccount.SUPPORTED_CURRENCIES)), JAPAN_BANK = new PaymentMethod(JAPAN_BANK_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(JapanBankAccount.SUPPORTED_CURRENCIES)), AUSTRALIA_PAYID = new PaymentMethod(AUSTRALIA_PAYID_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(AustraliaPayidAccount.SUPPORTED_CURRENCIES)), ALI_PAY = new PaymentMethod(ALI_PAY_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(AliPayAccount.SUPPORTED_CURRENCIES)), WECHAT_PAY = new PaymentMethod(WECHAT_PAY_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(WeChatPayAccount.SUPPORTED_CURRENCIES)), PROMPT_PAY = new PaymentMethod(PROMPT_PAY_ID, DAY, DEFAULT_TRADE_LIMIT_LOW_RISK, PaymentMethod.getAssetCodes(PromptPayAccount.SUPPORTED_CURRENCIES)), BLOCK_CHAINS = new PaymentMethod(BLOCK_CHAINS_ID, DAY, DEFAULT_TRADE_LIMIT_CRYPTO, Arrays.asList(new String[0])), BLOCK_CHAINS_INSTANT = new PaymentMethod(BLOCK_CHAINS_INSTANT_ID, TimeUnit.HOURS.toMillis(1L), DEFAULT_TRADE_LIMIT_CRYPTO, Arrays.asList(new String[0])));
        paymentMethods.sort((o1, o2) -> {
            String id2;
            String id1 = o1.getId();
            if (id1.equals(ZELLE_ID)) {
                id1 = ZELLE_ID;
            }
            if ((id2 = o2.getId()).equals(ZELLE_ID)) {
                id2 = ZELLE_ID;
            }
            return id1.compareTo(id2);
        });
    }
}

