/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import haveno.common.consensus.UsedForTradeContractJson;
import haveno.common.crypto.CryptoUtils;
import haveno.common.crypto.Hash;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.util.JsonExclude;
import haveno.common.util.Utilities;
import haveno.core.proto.CoreProtoResolver;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccountPayload;

public abstract class PaymentAccountPayload
implements NetworkPayload,
UsedForTradeContractJson {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountPayload.class);
    public static final String SALT = "salt";
    protected final String paymentMethodId;
    protected final String id;
    protected final long maxTradePeriod;
    @JsonExclude
    protected final Map<String, String> excludeFromJsonDataMap;
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().serializeNulls();

    PaymentAccountPayload(String paymentMethodId, String id) {
        this(paymentMethodId, id, -1L, new HashMap<String, String>());
    }

    protected PaymentAccountPayload(String paymentMethodId, String id, long maxTradePeriod, Map<String, String> excludeFromJsonDataMapParam) {
        this.paymentMethodId = paymentMethodId;
        this.id = id;
        this.maxTradePeriod = maxTradePeriod;
        this.excludeFromJsonDataMap = excludeFromJsonDataMapParam;
        if (!this.excludeFromJsonDataMap.containsKey(SALT)) {
            this.excludeFromJsonDataMap.put(SALT, Utilities.encodeToHex((byte[])CryptoUtils.getRandomBytes((int)32)));
        }
    }

    protected PaymentAccountPayload.Builder getPaymentAccountPayloadBuilder() {
        PaymentAccountPayload.Builder builder = protobuf.PaymentAccountPayload.newBuilder().setPaymentMethodId(this.paymentMethodId).setMaxTradePeriod(this.maxTradePeriod).setId(this.id);
        builder.putAllExcludeFromJsonData(this.excludeFromJsonDataMap);
        return builder;
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto, CoreProtoResolver coreProtoResolver) {
        return coreProtoResolver.fromProto(proto);
    }

    public String toJson() {
        return gsonBuilder.create().toJson((Object)this);
    }

    public abstract String getPaymentDetails();

    public abstract String getPaymentDetailsForTradePopup();

    public byte[] getHash() {
        return Hash.getRipemd160hash((byte[])this.toProtoMessage().toByteArray());
    }

    public byte[] getSalt() {
        Preconditions.checkArgument((boolean)this.excludeFromJsonDataMap.containsKey(SALT), (Object)"Salt must have been set in excludeFromJsonDataMap.");
        return Utilities.decodeFromHex((String)this.excludeFromJsonDataMap.get(SALT));
    }

    public void setSalt(byte[] salt) {
        this.excludeFromJsonDataMap.put(SALT, Utilities.encodeToHex((byte[])salt));
    }

    public abstract byte[] getAgeWitnessInputData();

    protected byte[] getAgeWitnessInputData(byte[] data) {
        return ArrayUtils.addAll((byte[])this.paymentMethodId.getBytes(StandardCharsets.UTF_8), (byte[])data);
    }

    public String getOwnerId() {
        return null;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getId() {
        return this.id;
    }

    public long getMaxTradePeriod() {
        return this.maxTradePeriod;
    }

    public Map<String, String> getExcludeFromJsonDataMap() {
        return this.excludeFromJsonDataMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentAccountPayload)) {
            return false;
        }
        PaymentAccountPayload other = (PaymentAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxTradePeriod() != other.getMaxTradePeriod()) {
            return false;
        }
        String this$paymentMethodId = this.getPaymentMethodId();
        String other$paymentMethodId = other.getPaymentMethodId();
        if (this$paymentMethodId == null ? other$paymentMethodId != null : !this$paymentMethodId.equals(other$paymentMethodId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$excludeFromJsonDataMap = this.getExcludeFromJsonDataMap();
        Map<String, String> other$excludeFromJsonDataMap = other.getExcludeFromJsonDataMap();
        return !(this$excludeFromJsonDataMap == null ? other$excludeFromJsonDataMap != null : !((Object)this$excludeFromJsonDataMap).equals(other$excludeFromJsonDataMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentAccountPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxTradePeriod = this.getMaxTradePeriod();
        result = result * 59 + (int)($maxTradePeriod >>> 32 ^ $maxTradePeriod);
        String $paymentMethodId = this.getPaymentMethodId();
        result = result * 59 + ($paymentMethodId == null ? 43 : $paymentMethodId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $excludeFromJsonDataMap = this.getExcludeFromJsonDataMap();
        result = result * 59 + ($excludeFromJsonDataMap == null ? 43 : ((Object)$excludeFromJsonDataMap).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentAccountPayload(paymentMethodId=" + this.getPaymentMethodId() + ", id=" + this.getId() + ", maxTradePeriod=" + this.getMaxTradePeriod() + ", excludeFromJsonDataMap=" + String.valueOf(this.getExcludeFromJsonDataMap()) + ")";
    }
}

