/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.NequiAccountPayload;
import protobuf.PaymentAccountPayload;

public final class NequiAccountPayload
extends CountryBasedPaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(NequiAccountPayload.class);
    private String mobileNr = "";

    public NequiAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private NequiAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String mobileNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.mobileNr = mobileNr;
    }

    public Message toProtoMessage() {
        NequiAccountPayload.Builder builder = protobuf.NequiAccountPayload.newBuilder().setMobileNr(this.mobileNr);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setNequiAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static NequiAccountPayload fromProto(PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.NequiAccountPayload paytmAccountPayloadPB = countryBasedPaymentAccountPayload.getNequiAccountPayload();
        return new NequiAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), paytmAccountPayloadPB.getMobileNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.mobile") + " " + this.mobileNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.mobileNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NequiAccountPayload)) {
            return false;
        }
        NequiAccountPayload other = (NequiAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mobileNr = this.getMobileNr();
        String other$mobileNr = other.getMobileNr();
        return !(this$mobileNr == null ? other$mobileNr != null : !this$mobileNr.equals(other$mobileNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NequiAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mobileNr = this.getMobileNr();
        result = result * 59 + ($mobileNr == null ? 43 : $mobileNr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NequiAccountPayload(mobileNr=" + this.getMobileNr() + ")";
    }

    public void setMobileNr(String mobileNr) {
        this.mobileNr = mobileNr;
    }

    public String getMobileNr() {
        return this.mobileNr;
    }
}

