/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.IfscBasedAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.IfscBasedAccountPayload;
import protobuf.PaymentAccountPayload;

public final class NeftAccountPayload
extends IfscBasedAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(NeftAccountPayload.class);

    public NeftAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private NeftAccountPayload(String paymentMethod, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String accountNr, String ifsc, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, countryCode, acceptedCountryCodes, holderName, accountNr, ifsc, maxTradePeriod, excludeFromJsonDataMap);
    }

    public Message toProtoMessage() {
        IfscBasedAccountPayload.Builder ifscBasedAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().getIfscBasedAccountPayloadBuilder().setNeftAccountPayload(protobuf.NeftAccountPayload.newBuilder());
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setIfscBasedAccountPayload(ifscBasedAccountPayloadBuilder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder).build();
    }

    public static NeftAccountPayload fromProto(PaymentAccountPayload proto) {
        CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.IfscBasedAccountPayload ifscBasedAccountPayloadPB = countryBasedPaymentAccountPayload.getIfscBasedAccountPayload();
        return new NeftAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), ifscBasedAccountPayloadPB.getHolderName(), ifscBasedAccountPayloadPB.getAccountNr(), ifscBasedAccountPayloadPB.getIfsc(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.getWithCol("payment.account.no") + " " + this.accountNr + Res.getWithCol("payment.ifsc") + " " + this.ifsc;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String accountNr = this.accountNr == null ? "" : this.accountNr;
        return super.getAgeWitnessInputData(accountNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getHolderName() {
        return this.getOwnerId();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NeftAccountPayload)) {
            return false;
        }
        NeftAccountPayload other = (NeftAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NeftAccountPayload;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "NeftAccountPayload()";
    }
}

