/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoneyBeamAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(MoneyBeamAccountPayload.class);
    private String accountId = "";

    public MoneyBeamAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private MoneyBeamAccountPayload(String paymentMethod, String id, String accountId, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.accountId = accountId;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setMoneyBeamAccountPayload(protobuf.MoneyBeamAccountPayload.newBuilder().setAccountId(this.accountId)).build();
    }

    public static MoneyBeamAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new MoneyBeamAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getMoneyBeamAccountPayload().getAccountId(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account") + " " + this.accountId;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.accountId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoneyBeamAccountPayload)) {
            return false;
        }
        MoneyBeamAccountPayload other = (MoneyBeamAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MoneyBeamAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MoneyBeamAccountPayload(accountId=" + this.getAccountId() + ")";
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }
}

