/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JapanBankAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(JapanBankAccountPayload.class);
    private String bankName = "";
    private String bankCode = "";
    private String bankBranchName = "";
    private String bankBranchCode = "";
    private String bankAccountType = "";
    private String bankAccountName = "";
    private String bankAccountNumber = "";

    public JapanBankAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private JapanBankAccountPayload(String paymentMethod, String id, String bankName, String bankCode, String bankBranchName, String bankBranchCode, String bankAccountType, String bankAccountName, String bankAccountNumber, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.bankName = bankName;
        this.bankCode = bankCode;
        this.bankBranchName = bankBranchName;
        this.bankBranchCode = bankBranchCode;
        this.bankAccountType = bankAccountType;
        this.bankAccountName = bankAccountName;
        this.bankAccountNumber = bankAccountNumber;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setJapanBankAccountPayload(protobuf.JapanBankAccountPayload.newBuilder().setBankName(this.bankName).setBankCode(this.bankCode).setBankBranchName(this.bankBranchName).setBankBranchCode(this.bankBranchCode).setBankAccountType(this.bankAccountType).setBankAccountName(this.bankAccountName).setBankAccountNumber(this.bankAccountNumber)).build();
    }

    public static JapanBankAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.JapanBankAccountPayload japanBankAccountPayload = proto.getJapanBankAccountPayload();
        return new JapanBankAccountPayload(proto.getPaymentMethodId(), proto.getId(), japanBankAccountPayload.getBankName(), japanBankAccountPayload.getBankCode(), japanBankAccountPayload.getBankBranchName(), japanBankAccountPayload.getBankBranchCode(), japanBankAccountPayload.getBankAccountType(), japanBankAccountPayload.getBankAccountName(), japanBankAccountPayload.getBankAccountNumber(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.get("payment.japan.bank") + ": " + this.bankName + "(" + this.bankCode + ")\n" + Res.get("payment.japan.branch") + ": " + this.bankBranchName + "(" + this.bankBranchCode + ")\n" + Res.get("payment.japan.account") + ": " + this.bankAccountType + " " + this.bankAccountNumber + "\n" + Res.get("payment.japan.recipient") + ": " + this.bankAccountName;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String all = this.bankName + this.bankBranchName + this.bankAccountType + this.bankAccountNumber + this.bankAccountName;
        return super.getAgeWitnessInputData(all.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getHolderName() {
        return this.bankAccountName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JapanBankAccountPayload)) {
            return false;
        }
        JapanBankAccountPayload other = (JapanBankAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bankName = this.getBankName();
        String other$bankName = other.getBankName();
        if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
            return false;
        }
        String this$bankCode = this.getBankCode();
        String other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
            return false;
        }
        String this$bankBranchName = this.getBankBranchName();
        String other$bankBranchName = other.getBankBranchName();
        if (this$bankBranchName == null ? other$bankBranchName != null : !this$bankBranchName.equals(other$bankBranchName)) {
            return false;
        }
        String this$bankBranchCode = this.getBankBranchCode();
        String other$bankBranchCode = other.getBankBranchCode();
        if (this$bankBranchCode == null ? other$bankBranchCode != null : !this$bankBranchCode.equals(other$bankBranchCode)) {
            return false;
        }
        String this$bankAccountType = this.getBankAccountType();
        String other$bankAccountType = other.getBankAccountType();
        if (this$bankAccountType == null ? other$bankAccountType != null : !this$bankAccountType.equals(other$bankAccountType)) {
            return false;
        }
        String this$bankAccountName = this.getBankAccountName();
        String other$bankAccountName = other.getBankAccountName();
        if (this$bankAccountName == null ? other$bankAccountName != null : !this$bankAccountName.equals(other$bankAccountName)) {
            return false;
        }
        String this$bankAccountNumber = this.getBankAccountNumber();
        String other$bankAccountNumber = other.getBankAccountNumber();
        return !(this$bankAccountNumber == null ? other$bankAccountNumber != null : !this$bankAccountNumber.equals(other$bankAccountNumber));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JapanBankAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bankName = this.getBankName();
        result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
        String $bankCode = this.getBankCode();
        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
        String $bankBranchName = this.getBankBranchName();
        result = result * 59 + ($bankBranchName == null ? 43 : $bankBranchName.hashCode());
        String $bankBranchCode = this.getBankBranchCode();
        result = result * 59 + ($bankBranchCode == null ? 43 : $bankBranchCode.hashCode());
        String $bankAccountType = this.getBankAccountType();
        result = result * 59 + ($bankAccountType == null ? 43 : $bankAccountType.hashCode());
        String $bankAccountName = this.getBankAccountName();
        result = result * 59 + ($bankAccountName == null ? 43 : $bankAccountName.hashCode());
        String $bankAccountNumber = this.getBankAccountNumber();
        result = result * 59 + ($bankAccountNumber == null ? 43 : $bankAccountNumber.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "JapanBankAccountPayload(bankName=" + this.getBankName() + ", bankCode=" + this.getBankCode() + ", bankBranchName=" + this.getBankBranchName() + ", bankBranchCode=" + this.getBankBranchCode() + ", bankAccountType=" + this.getBankAccountType() + ", bankAccountName=" + this.getBankAccountName() + ", bankAccountNumber=" + this.getBankAccountNumber() + ")";
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public void setBankBranchCode(String bankBranchCode) {
        this.bankBranchCode = bankBranchCode;
    }

    public void setBankAccountType(String bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getBankBranchName() {
        return this.bankBranchName;
    }

    public String getBankBranchCode() {
        return this.bankBranchCode;
    }

    public String getBankAccountType() {
        return this.bankAccountType;
    }

    public String getBankAccountName() {
        return this.bankAccountName;
    }

    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }
}

