/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InteracETransferAccountPayload
extends PaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(InteracETransferAccountPayload.class);
    private String emailOrMobileNr = "";
    private String holderName = "";
    private String question = "";
    private String answer = "";

    public InteracETransferAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private InteracETransferAccountPayload(String paymentMethod, String id, String emailOrMobileNr, String holderName, String question, String answer, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.emailOrMobileNr = emailOrMobileNr;
        this.holderName = holderName;
        this.question = question;
        this.answer = answer;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setInteracETransferAccountPayload(protobuf.InteracETransferAccountPayload.newBuilder().setEmailOrMobileNr(this.emailOrMobileNr).setHolderName(this.holderName).setQuestion(this.question).setAnswer(this.answer)).build();
    }

    public static InteracETransferAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new InteracETransferAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getInteracETransferAccountPayload().getEmailOrMobileNr(), proto.getInteracETransferAccountPayload().getHolderName(), proto.getInteracETransferAccountPayload().getQuestion(), proto.getInteracETransferAccountPayload().getAnswer(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.account.owner") + " " + this.holderName + ", " + Res.get("payment.email") + " " + this.emailOrMobileNr + ", " + Res.getWithCol("payment.secret") + " " + this.question + ", " + Res.getWithCol("payment.answer") + " " + this.answer;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + Res.getWithCol("payment.email") + " " + this.emailOrMobileNr + "\n" + Res.getWithCol("payment.secret") + " " + this.question + "\n" + Res.getWithCol("payment.answer") + " " + this.answer;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll((byte[])this.emailOrMobileNr.getBytes(StandardCharsets.UTF_8), (byte[])ArrayUtils.addAll((byte[])this.question.getBytes(StandardCharsets.UTF_8), (byte[])this.answer.getBytes(StandardCharsets.UTF_8))));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteracETransferAccountPayload)) {
            return false;
        }
        InteracETransferAccountPayload other = (InteracETransferAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$emailOrMobileNr = this.getEmailOrMobileNr();
        String other$emailOrMobileNr = other.getEmailOrMobileNr();
        if (this$emailOrMobileNr == null ? other$emailOrMobileNr != null : !this$emailOrMobileNr.equals(other$emailOrMobileNr)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        String this$answer = this.getAnswer();
        String other$answer = other.getAnswer();
        return !(this$answer == null ? other$answer != null : !this$answer.equals(other$answer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InteracETransferAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $emailOrMobileNr = this.getEmailOrMobileNr();
        result = result * 59 + ($emailOrMobileNr == null ? 43 : $emailOrMobileNr.hashCode());
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        String $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "InteracETransferAccountPayload(emailOrMobileNr=" + this.getEmailOrMobileNr() + ", holderName=" + this.getHolderName() + ", question=" + this.getQuestion() + ", answer=" + this.getAnswer() + ")";
    }

    public void setEmailOrMobileNr(String emailOrMobileNr) {
        this.emailOrMobileNr = emailOrMobileNr;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getEmailOrMobileNr() {
        return this.emailOrMobileNr;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getAnswer() {
        return this.answer;
    }
}

