/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import haveno.core.locale.BankUtil;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import haveno.core.payment.payload.PayloadWithHolderName;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.IfscBasedAccountPayload;
import protobuf.PaymentAccountPayload;

public abstract class IfscBasedAccountPayload
extends CountryBasedPaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(IfscBasedAccountPayload.class);
    protected String holderName = "";
    protected String ifsc = "";
    protected String accountNr = "";

    protected IfscBasedAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    protected IfscBasedAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String accountNr, String ifsc, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.accountNr = accountNr;
        this.ifsc = ifsc;
    }

    @Override
    public PaymentAccountPayload.Builder getPaymentAccountPayloadBuilder() {
        IfscBasedAccountPayload.Builder builder = protobuf.IfscBasedAccountPayload.newBuilder().setHolderName(this.holderName);
        Optional.ofNullable(this.ifsc).ifPresent(arg_0 -> ((IfscBasedAccountPayload.Builder)builder).setIfsc(arg_0));
        Optional.ofNullable(this.accountNr).ifPresent(arg_0 -> ((IfscBasedAccountPayload.Builder)builder).setAccountNr(arg_0));
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = super.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setIfscBasedAccountPayload(builder);
        return super.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder);
    }

    @Override
    public String getPaymentDetails() {
        return "Ifsc account transfer - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + BankUtil.getAccountNrLabel(this.countryCode) + ": " + this.accountNr + "\n" + BankUtil.getBankIdLabel(this.countryCode) + ": " + this.ifsc + "\n" + Res.getWithCol("payment.bank.country") + " " + CountryUtil.getNameByCode(this.countryCode);
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String all = this.accountNr + this.ifsc;
        return super.getAgeWitnessInputData(all.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getOwnerId() {
        return this.holderName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IfscBasedAccountPayload)) {
            return false;
        }
        IfscBasedAccountPayload other = (IfscBasedAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$ifsc = this.getIfsc();
        String other$ifsc = other.getIfsc();
        if (this$ifsc == null ? other$ifsc != null : !this$ifsc.equals(other$ifsc)) {
            return false;
        }
        String this$accountNr = this.getAccountNr();
        String other$accountNr = other.getAccountNr();
        return !(this$accountNr == null ? other$accountNr != null : !this$accountNr.equals(other$accountNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IfscBasedAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $ifsc = this.getIfsc();
        result = result * 59 + ($ifsc == null ? 43 : $ifsc.hashCode());
        String $accountNr = this.getAccountNr();
        result = result * 59 + ($accountNr == null ? 43 : $accountNr.hashCode());
        return result;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setIfsc(String ifsc) {
        this.ifsc = ifsc;
    }

    public void setAccountNr(String accountNr) {
        this.accountNr = accountNr;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getIfsc() {
        return this.ifsc;
    }

    public String getAccountNr() {
        return this.accountNr;
    }

    @Override
    public String toString() {
        return "IfscBasedAccountPayload(holderName=" + this.getHolderName() + ", ifsc=" + this.getIfsc() + ", accountNr=" + this.getAccountNr() + ")";
    }
}

