/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FasterPaymentsAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(FasterPaymentsAccountPayload.class);
    private String holderName = "";
    private String sortCode = "";
    private String accountNr = "";

    public FasterPaymentsAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private FasterPaymentsAccountPayload(String paymentMethod, String id, String holderName, String sortCode, String accountNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.sortCode = sortCode;
        this.accountNr = accountNr;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setFasterPaymentsAccountPayload(protobuf.FasterPaymentsAccountPayload.newBuilder().setHolderName(this.holderName).setSortCode(this.sortCode).setAccountNr(this.accountNr)).build();
    }

    public static FasterPaymentsAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new FasterPaymentsAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getFasterPaymentsAccountPayload().getHolderName(), proto.getFasterPaymentsAccountPayload().getSortCode(), proto.getFasterPaymentsAccountPayload().getAccountNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return (String)(this.getHolderName().isEmpty() ? "" : Res.getWithCol("payment.account.owner") + " " + this.getHolderName() + "\n") + "UK Sort code: " + this.sortCode + "\n" + Res.getWithCol("payment.accountNr") + " " + this.accountNr;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll((byte[])this.sortCode.getBytes(StandardCharsets.UTF_8), (byte[])this.accountNr.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FasterPaymentsAccountPayload)) {
            return false;
        }
        FasterPaymentsAccountPayload other = (FasterPaymentsAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$sortCode = this.getSortCode();
        String other$sortCode = other.getSortCode();
        if (this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode)) {
            return false;
        }
        String this$accountNr = this.getAccountNr();
        String other$accountNr = other.getAccountNr();
        return !(this$accountNr == null ? other$accountNr != null : !this$accountNr.equals(other$accountNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FasterPaymentsAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $sortCode = this.getSortCode();
        result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
        String $accountNr = this.getAccountNr();
        result = result * 59 + ($accountNr == null ? 43 : $accountNr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FasterPaymentsAccountPayload(holderName=" + this.getHolderName() + ", sortCode=" + this.getSortCode() + ", accountNr=" + this.getAccountNr() + ")";
    }

    public String getHolderName() {
        return this.holderName;
    }

    public String getSortCode() {
        return this.sortCode;
    }

    public String getAccountNr() {
        return this.accountNr;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public void setAccountNr(String accountNr) {
        this.accountNr = accountNr;
    }
}

