/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;

public abstract class CountryBasedPaymentAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(CountryBasedPaymentAccountPayload.class);
    protected String countryCode = "";
    protected List<String> acceptedCountryCodes = new ArrayList<String>();

    CountryBasedPaymentAccountPayload(String paymentMethodName, String id) {
        super(paymentMethodName, id);
    }

    protected CountryBasedPaymentAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, maxTradePeriod, excludeFromJsonDataMap);
        this.countryCode = countryCode;
        this.acceptedCountryCodes = acceptedCountryCodes;
    }

    @Override
    protected PaymentAccountPayload.Builder getPaymentAccountPayloadBuilder() {
        CountryBasedPaymentAccountPayload.Builder builder = protobuf.CountryBasedPaymentAccountPayload.newBuilder().setCountryCode(this.countryCode).addAllAcceptedCountryCodes(this.acceptedCountryCodes);
        return super.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(builder);
    }

    @Override
    public abstract String getPaymentDetails();

    @Override
    public abstract String getPaymentDetailsForTradePopup();

    @Override
    protected byte[] getAgeWitnessInputData(byte[] data) {
        return super.getAgeWitnessInputData(ArrayUtils.addAll((byte[])this.countryCode.getBytes(StandardCharsets.UTF_8), (byte[])data));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountryBasedPaymentAccountPayload)) {
            return false;
        }
        CountryBasedPaymentAccountPayload other = (CountryBasedPaymentAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        List<String> this$acceptedCountryCodes = this.getAcceptedCountryCodes();
        List<String> other$acceptedCountryCodes = other.getAcceptedCountryCodes();
        return !(this$acceptedCountryCodes == null ? other$acceptedCountryCodes != null : !((Object)this$acceptedCountryCodes).equals(other$acceptedCountryCodes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CountryBasedPaymentAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        List<String> $acceptedCountryCodes = this.getAcceptedCountryCodes();
        result = result * 59 + ($acceptedCountryCodes == null ? 43 : ((Object)$acceptedCountryCodes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CountryBasedPaymentAccountPayload(countryCode=" + this.getCountryCode() + ", acceptedCountryCodes=" + String.valueOf(this.getAcceptedCountryCodes()) + ")";
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setAcceptedCountryCodes(List<String> acceptedCountryCodes) {
        this.acceptedCountryCodes = acceptedCountryCodes;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public List<String> getAcceptedCountryCodes() {
        return this.acceptedCountryCodes;
    }
}

