/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.BankUtil;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CashDepositAccountPayload;
import protobuf.CountryBasedPaymentAccountPayload;

public class CashDepositAccountPayload
extends BankAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(CashDepositAccountPayload.class);
    @Nullable
    private String holderEmail;
    @Nullable
    private String requirements;

    public CashDepositAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private CashDepositAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, @Nullable String holderEmail, @Nullable String bankName, @Nullable String branchId, @Nullable String accountNr, @Nullable String accountType, @Nullable String requirements, @Nullable String holderTaxId, @Nullable String bankId, @Nullable String nationalAccountId, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, holderName, bankName, branchId, accountNr, accountType, holderTaxId, bankId, nationalAccountId, maxTradePeriod, excludeFromJsonDataMap);
        this.holderEmail = holderEmail;
        this.requirements = requirements;
    }

    public Message toProtoMessage() {
        CashDepositAccountPayload.Builder builder = protobuf.CashDepositAccountPayload.newBuilder().setHolderName(this.holderName);
        Optional.ofNullable(this.holderEmail).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setHolderEmail(arg_0));
        Optional.ofNullable(this.bankName).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setBankName(arg_0));
        Optional.ofNullable(this.branchId).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setBranchId(arg_0));
        Optional.ofNullable(this.accountNr).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setAccountNr(arg_0));
        Optional.ofNullable(this.accountType).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setAccountType(arg_0));
        Optional.ofNullable(this.requirements).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setRequirements(arg_0));
        Optional.ofNullable(this.holderTaxId).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setHolderTaxId(arg_0));
        Optional.ofNullable(this.bankId).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setBankId(arg_0));
        Optional.ofNullable(this.nationalAccountId).ifPresent(arg_0 -> ((CashDepositAccountPayload.Builder)builder).setNationalAccountId(arg_0));
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setCashDepositAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.CashDepositAccountPayload cashDepositAccountPayload = countryBasedPaymentAccountPayload.getCashDepositAccountPayload();
        return new CashDepositAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), cashDepositAccountPayload.getHolderName(), cashDepositAccountPayload.getHolderEmail().isEmpty() ? null : cashDepositAccountPayload.getHolderEmail(), cashDepositAccountPayload.getBankName().isEmpty() ? null : cashDepositAccountPayload.getBankName(), cashDepositAccountPayload.getBranchId().isEmpty() ? null : cashDepositAccountPayload.getBranchId(), cashDepositAccountPayload.getAccountNr().isEmpty() ? null : cashDepositAccountPayload.getAccountNr(), cashDepositAccountPayload.getAccountType().isEmpty() ? null : cashDepositAccountPayload.getAccountType(), cashDepositAccountPayload.getRequirements().isEmpty() ? null : cashDepositAccountPayload.getRequirements(), cashDepositAccountPayload.getHolderTaxId().isEmpty() ? null : cashDepositAccountPayload.getHolderTaxId(), cashDepositAccountPayload.getBankId().isEmpty() ? null : cashDepositAccountPayload.getBankId(), cashDepositAccountPayload.getNationalAccountId().isEmpty() ? null : cashDepositAccountPayload.getNationalAccountId(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return "Cash deposit - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        String bankName = BankUtil.isBankNameRequired(this.countryCode) ? BankUtil.getBankNameLabel(this.countryCode) + ": " + this.bankName + "\n" : "";
        String bankId = BankUtil.isBankIdRequired(this.countryCode) ? BankUtil.getBankIdLabel(this.countryCode) + ": " + this.bankId + "\n" : "";
        String branchId = BankUtil.isBranchIdRequired(this.countryCode) ? BankUtil.getBranchIdLabel(this.countryCode) + ": " + this.branchId + "\n" : "";
        String nationalAccountId = BankUtil.isNationalAccountIdRequired(this.countryCode) ? BankUtil.getNationalAccountIdLabel(this.countryCode) + ": " + this.nationalAccountId + "\n" : "";
        String accountNr = BankUtil.isAccountNrRequired(this.countryCode) ? BankUtil.getAccountNrLabel(this.countryCode) + ": " + this.accountNr + "\n" : "";
        String accountType = BankUtil.isAccountTypeRequired(this.countryCode) ? BankUtil.getAccountTypeLabel(this.countryCode) + ": " + this.accountType + "\n" : "";
        String holderTaxIdString = BankUtil.isHolderIdRequired(this.countryCode) ? BankUtil.getHolderIdLabel(this.countryCode) + ": " + this.holderTaxId + "\n" : "";
        String requirementsString = this.requirements != null && !this.requirements.isEmpty() ? Res.getWithCol("payment.extras") + " " + this.requirements + "\n" : "";
        String emailString = this.holderEmail != null ? Res.getWithCol("payment.email") + " " + this.holderEmail + "\n" : "";
        return Res.getWithCol("payment.account.owner") + " " + this.holderName + "\n" + emailString + bankName + bankId + branchId + nationalAccountId + accountNr + accountType + holderTaxIdString + requirementsString + Res.getWithCol("payment.bank.country") + " " + CountryUtil.getNameByCode(this.countryCode);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashDepositAccountPayload)) {
            return false;
        }
        CashDepositAccountPayload other = (CashDepositAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderEmail = this.getHolderEmail();
        String other$holderEmail = other.getHolderEmail();
        if (this$holderEmail == null ? other$holderEmail != null : !this$holderEmail.equals(other$holderEmail)) {
            return false;
        }
        String this$requirements = this.getRequirements();
        String other$requirements = other.getRequirements();
        return !(this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CashDepositAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderEmail = this.getHolderEmail();
        result = result * 59 + ($holderEmail == null ? 43 : $holderEmail.hashCode());
        String $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : $requirements.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CashDepositAccountPayload(holderEmail=" + this.getHolderEmail() + ", requirements=" + this.getRequirements() + ")";
    }

    public void setHolderEmail(@Nullable String holderEmail) {
        this.holderEmail = holderEmail;
    }

    public void setRequirements(@Nullable String requirements) {
        this.requirements = requirements;
    }

    @Nullable
    public String getHolderEmail() {
        return this.holderEmail;
    }

    @Nullable
    public String getRequirements() {
        return this.requirements;
    }
}

