/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CashAtAtmAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(CashAtAtmAccountPayload.class);
    private String extraInfo = "";

    public CashAtAtmAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private CashAtAtmAccountPayload(String paymentMethod, String id, String extraInfo, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.extraInfo = extraInfo;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setCashAtAtmAccountPayload(protobuf.CashAtAtmAccountPayload.newBuilder().setExtraInfo(this.extraInfo)).build();
    }

    public static CashAtAtmAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new CashAtAtmAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getCashAtAtmAccountPayload().getExtraInfo(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.getWithCol("payment.shared.extraInfo") + " " + this.extraInfo;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return Res.getWithCol("payment.shared.extraInfo") + " " + this.extraInfo;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(ArrayUtils.addAll((byte[])this.id.getBytes(StandardCharsets.UTF_8), (byte[])new byte[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashAtAtmAccountPayload)) {
            return false;
        }
        CashAtAtmAccountPayload other = (CashAtAtmAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CashAtAtmAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CashAtAtmAccountPayload(extraInfo=" + this.getExtraInfo() + ")";
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

