/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdvancedCashAccountPayload
extends PaymentAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(AdvancedCashAccountPayload.class);
    private String accountNr = "";

    public AdvancedCashAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private AdvancedCashAccountPayload(String paymentMethod, String id, String accountNr, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethod, id, maxTradePeriod, excludeFromJsonDataMap);
        this.accountNr = accountNr;
    }

    public Message toProtoMessage() {
        return this.getPaymentAccountPayloadBuilder().setAdvancedCashAccountPayload(protobuf.AdvancedCashAccountPayload.newBuilder().setAccountNr(this.accountNr)).build();
    }

    public static AdvancedCashAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        return new AdvancedCashAccountPayload(proto.getPaymentMethodId(), proto.getId(), proto.getAdvancedCashAccountPayload().getAccountNr(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + Res.getWithCol("payment.wallet") + " " + this.accountNr;
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        return this.getPaymentDetails();
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        return super.getAgeWitnessInputData(this.accountNr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancedCashAccountPayload)) {
            return false;
        }
        AdvancedCashAccountPayload other = (AdvancedCashAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountNr = this.getAccountNr();
        String other$accountNr = other.getAccountNr();
        return !(this$accountNr == null ? other$accountNr != null : !this$accountNr.equals(other$accountNr));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AdvancedCashAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountNr = this.getAccountNr();
        result = result * 59 + ($accountNr == null ? 43 : $accountNr.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AdvancedCashAccountPayload(accountNr=" + this.getAccountNr() + ")";
    }

    public void setAccountNr(String accountNr) {
        this.accountNr = accountNr;
    }

    public String getAccountNr() {
        return this.accountNr;
    }
}

