/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.Res;
import haveno.core.payment.payload.BankAccountPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AchTransferAccountPayload;
import protobuf.BankAccountPayload;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.PaymentAccountPayload;

public final class AchTransferAccountPayload
extends BankAccountPayload {
    private static final Logger log = LoggerFactory.getLogger(AchTransferAccountPayload.class);
    private String holderAddress = "";

    public AchTransferAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private AchTransferAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String bankName, String branchId, String accountNr, String accountType, String holderAddress, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, holderName, bankName, branchId, accountNr, accountType, null, null, null, maxTradePeriod, excludeFromJsonDataMap);
        this.holderAddress = holderAddress;
    }

    public Message toProtoMessage() {
        AchTransferAccountPayload.Builder builder = protobuf.AchTransferAccountPayload.newBuilder().setHolderAddress(this.holderAddress);
        BankAccountPayload.Builder bankAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().getBankAccountPayloadBuilder().setAchTransferAccountPayload(builder);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayloadBuilder = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setBankAccountPayload(bankAccountPayloadBuilder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayloadBuilder).build();
    }

    public static AchTransferAccountPayload fromProto(PaymentAccountPayload proto) {
        CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.BankAccountPayload bankAccountPayloadPB = countryBasedPaymentAccountPayload.getBankAccountPayload();
        protobuf.AchTransferAccountPayload accountPayloadPB = bankAccountPayloadPB.getAchTransferAccountPayload();
        return new AchTransferAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), bankAccountPayloadPB.getHolderName(), bankAccountPayloadPB.getBankName().isEmpty() ? null : bankAccountPayloadPB.getBankName(), bankAccountPayloadPB.getBranchId().isEmpty() ? null : bankAccountPayloadPB.getBranchId(), bankAccountPayloadPB.getAccountNr().isEmpty() ? null : bankAccountPayloadPB.getAccountNr(), bankAccountPayloadPB.getAccountType().isEmpty() ? null : bankAccountPayloadPB.getAccountType(), accountPayloadPB.getHolderAddress().isEmpty() ? null : accountPayloadPB.getHolderAddress(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AchTransferAccountPayload)) {
            return false;
        }
        AchTransferAccountPayload other = (AchTransferAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderAddress = this.getHolderAddress();
        String other$holderAddress = other.getHolderAddress();
        return !(this$holderAddress == null ? other$holderAddress != null : !this$holderAddress.equals(other$holderAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AchTransferAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderAddress = this.getHolderAddress();
        result = result * 59 + ($holderAddress == null ? 43 : $holderAddress.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AchTransferAccountPayload(holderAddress=" + this.getHolderAddress() + ")";
    }

    public String getHolderAddress() {
        return this.holderAddress;
    }

    public void setHolderAddress(String holderAddress) {
        this.holderAddress = holderAddress;
    }
}

