/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.UpholdAccountPayload;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UpholdAccount
extends PaymentAccount {
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.ACCOUNT_OWNER, PaymentAccountFormField.FieldId.ACCOUNT_ID, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AED"), new TraditionalCurrency("ARS"), new TraditionalCurrency("AUD"), new TraditionalCurrency("BRL"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CHF"), new TraditionalCurrency("CNY"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("HKD"), new TraditionalCurrency("ILS"), new TraditionalCurrency("INR"), new TraditionalCurrency("JPY"), new TraditionalCurrency("KES"), new TraditionalCurrency("MXN"), new TraditionalCurrency("NOK"), new TraditionalCurrency("NZD"), new TraditionalCurrency("PHP"), new TraditionalCurrency("PLN"), new TraditionalCurrency("SEK"), new TraditionalCurrency("SGD"), new TraditionalCurrency("USD"));

    public UpholdAccount() {
        super(PaymentMethod.UPHOLD);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new UpholdAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setAccountId(String accountId) {
        ((UpholdAccountPayload)this.paymentAccountPayload).setAccountId(accountId);
    }

    public String getAccountId() {
        return ((UpholdAccountPayload)this.paymentAccountPayload).getAccountId();
    }

    public String getAccountOwner() {
        return ((UpholdAccountPayload)this.paymentAccountPayload).getAccountOwner();
    }

    public void setAccountOwner(String accountOwner) {
        if (accountOwner == null) {
            accountOwner = "";
        }
        ((UpholdAccountPayload)this.paymentAccountPayload).setAccountOwner(accountOwner);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpholdAccount)) {
            return false;
        }
        UpholdAccount other = (UpholdAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpholdAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

