/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.TransferwiseAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class TransferwiseAccount
extends PaymentAccount {
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.EMAIL, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AED"), new TraditionalCurrency("ARS"), new TraditionalCurrency("AUD"), new TraditionalCurrency("BGN"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CHF"), new TraditionalCurrency("CLP"), new TraditionalCurrency("CZK"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EGP"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("GEL"), new TraditionalCurrency("HKD"), new TraditionalCurrency("HUF"), new TraditionalCurrency("IDR"), new TraditionalCurrency("ILS"), new TraditionalCurrency("JPY"), new TraditionalCurrency("KES"), new TraditionalCurrency("KRW"), new TraditionalCurrency("MAD"), new TraditionalCurrency("MXN"), new TraditionalCurrency("MYR"), new TraditionalCurrency("NOK"), new TraditionalCurrency("NPR"), new TraditionalCurrency("NZD"), new TraditionalCurrency("PEN"), new TraditionalCurrency("PHP"), new TraditionalCurrency("PKR"), new TraditionalCurrency("PLN"), new TraditionalCurrency("RON"), new TraditionalCurrency("RUB"), new TraditionalCurrency("SEK"), new TraditionalCurrency("SGD"), new TraditionalCurrency("THB"), new TraditionalCurrency("TRY"), new TraditionalCurrency("UGX"), new TraditionalCurrency("VND"), new TraditionalCurrency("XOF"), new TraditionalCurrency("ZAR"), new TraditionalCurrency("ZMW"));

    public TransferwiseAccount() {
        super(PaymentMethod.TRANSFERWISE);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new TransferwiseAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    public void setEmail(String accountId) {
        ((TransferwiseAccountPayload)this.paymentAccountPayload).setEmail(accountId);
    }

    public String getEmail() {
        return ((TransferwiseAccountPayload)this.paymentAccountPayload).getEmail();
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setLabel("Currencies for receiving funds");
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferwiseAccount)) {
            return false;
        }
        TransferwiseAccount other = (TransferwiseAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TransferwiseAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

