/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.TikkieAccountPayload;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TikkieAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("EUR"));

    public TikkieAccount() {
        super(PaymentMethod.TIKKIE);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new TikkieAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setIban(String iban) {
        ((TikkieAccountPayload)this.paymentAccountPayload).setIban(iban);
    }

    public String getIban() {
        return ((TikkieAccountPayload)this.paymentAccountPayload).getIban();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.tikkie.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.tikkie.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.tikkie.info.account";
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TikkieAccount)) {
            return false;
        }
        TikkieAccount other = (TikkieAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TikkieAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

