/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountForm;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.SwishAccountPayload;
import haveno.core.payment.validation.SwishValidator;
import java.util.List;
import lombok.NonNull;

public final class SwishAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("SEK"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.MOBILE_NR, PaymentAccountFormField.FieldId.HOLDER_NAME, PaymentAccountFormField.FieldId.SALT);

    public SwishAccount() {
        super(PaymentMethod.SWISH);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new SwishAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setMobileNr(String mobileNr) {
        ((SwishAccountPayload)this.paymentAccountPayload).setMobileNr(mobileNr);
    }

    public String getMobileNr() {
        return ((SwishAccountPayload)this.paymentAccountPayload).getMobileNr();
    }

    public void setHolderName(String holderName) {
        ((SwishAccountPayload)this.paymentAccountPayload).setHolderName(holderName);
    }

    public String getHolderName() {
        return ((SwishAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    @Override
    public void validateFormField(PaymentAccountForm form, PaymentAccountFormField.FieldId fieldId, String value) {
        switch (fieldId) {
            case MOBILE_NR: {
                this.processValidationResult(new SwishValidator().validate(value));
                break;
            }
            default: {
                super.validateFormField(form, fieldId, value);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwishAccount)) {
            return false;
        }
        SwishAccount other = (SwishAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SwishAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

