/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.SwiftAccountPayload;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.NonNull;

public final class SwiftAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = new ArrayList<TraditionalCurrency>(CurrencyUtil.getAllSortedFiatCurrencies(Comparator.comparing(TradeCurrency::getCode)));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.BANK_SWIFT_CODE, PaymentAccountFormField.FieldId.BANK_COUNTRY_CODE, PaymentAccountFormField.FieldId.BANK_NAME, PaymentAccountFormField.FieldId.BANK_BRANCH, PaymentAccountFormField.FieldId.BANK_ADDRESS, PaymentAccountFormField.FieldId.INTERMEDIARY_SWIFT_CODE, PaymentAccountFormField.FieldId.INTERMEDIARY_COUNTRY_CODE, PaymentAccountFormField.FieldId.INTERMEDIARY_NAME, PaymentAccountFormField.FieldId.INTERMEDIARY_BRANCH, PaymentAccountFormField.FieldId.INTERMEDIARY_ADDRESS, PaymentAccountFormField.FieldId.BENEFICIARY_NAME, PaymentAccountFormField.FieldId.BENEFICIARY_ACCOUNT_NR, PaymentAccountFormField.FieldId.BENEFICIARY_ADDRESS, PaymentAccountFormField.FieldId.BENEFICIARY_CITY, PaymentAccountFormField.FieldId.BENEFICIARY_PHONE, PaymentAccountFormField.FieldId.SPECIAL_INSTRUCTIONS, PaymentAccountFormField.FieldId.SALT);

    public SwiftAccount() {
        super(PaymentMethod.SWIFT);
        this.tradeCurrencies.addAll(SUPPORTED_CURRENCIES);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new SwiftAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public SwiftAccountPayload getPayload() {
        return (SwiftAccountPayload)this.paymentAccountPayload;
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.swift.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.swift.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.swift.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwiftAccount)) {
            return false;
        }
        SwiftAccount other = (SwiftAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SwiftAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

