/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.StrikeAccountPayload;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class StrikeAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("USD"));
    public static final List<Country> SUPPORTED_COUNTRIES = CountryUtil.getCountries(List.of("US"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.COUNTRY, PaymentAccountFormField.FieldId.HOLDER_NAME, PaymentAccountFormField.FieldId.SALT);

    public StrikeAccount() {
        super(PaymentMethod.STRIKE);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new StrikeAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setHolderName(String accountId) {
        ((StrikeAccountPayload)this.paymentAccountPayload).setHolderName(accountId);
    }

    public String getHolderName() {
        return ((StrikeAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.strike.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.strike.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.strike.info.account";
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @Nullable
    @NotNull
    public List<Country> getSupportedCountries() {
        return SUPPORTED_COUNTRIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrikeAccount)) {
            return false;
        }
        StrikeAccount other = (StrikeAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StrikeAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

