/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.BankNameRestrictedBankAccount;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.SameCountryRestrictedBankAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.SpecificBanksAccountPayload;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public final class SpecificBanksAccount
extends CountryBasedPaymentAccount
implements BankNameRestrictedBankAccount,
SameCountryRestrictedBankAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = CurrencyUtil.getAllFiatCurrencies();

    public SpecificBanksAccount() {
        super(PaymentMethod.SPECIFIC_BANKS);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new SpecificBanksAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    public ArrayList<String> getAcceptedBanks() {
        return ((SpecificBanksAccountPayload)this.paymentAccountPayload).getAcceptedBanks();
    }

    @Override
    public String getBankId() {
        return ((SpecificBanksAccountPayload)this.paymentAccountPayload).getBankId();
    }

    @Override
    public String getCountryCode() {
        return this.getCountry() != null ? this.getCountry().code : "";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecificBanksAccount)) {
            return false;
        }
        SpecificBanksAccount other = (SpecificBanksAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpecificBanksAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

