/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountForm;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.BankAccount;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.SepaAccountPayload;
import haveno.core.payment.validation.SepaIBANValidator;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class SepaAccount
extends CountryBasedPaymentAccount
implements BankAccount {
    protected static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.HOLDER_NAME, PaymentAccountFormField.FieldId.IBAN, PaymentAccountFormField.FieldId.BIC, PaymentAccountFormField.FieldId.COUNTRY, PaymentAccountFormField.FieldId.ACCEPTED_COUNTRY_CODES, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("EUR"));

    public SepaAccount() {
        super(PaymentMethod.SEPA);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new SepaAccountPayload(this.paymentMethod.getId(), this.id, CountryUtil.getAllSepaCountries());
    }

    @Override
    public String getBankId() {
        return ((SepaAccountPayload)this.paymentAccountPayload).getBic();
    }

    public void setHolderName(String holderName) {
        ((SepaAccountPayload)this.paymentAccountPayload).setHolderName(holderName);
    }

    public String getHolderName() {
        return ((SepaAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setIban(String iban) {
        ((SepaAccountPayload)this.paymentAccountPayload).setIban(iban);
    }

    public String getIban() {
        return ((SepaAccountPayload)this.paymentAccountPayload).getIban();
    }

    public void setBic(String bic) {
        ((SepaAccountPayload)this.paymentAccountPayload).setBic(bic);
    }

    public String getBic() {
        return ((SepaAccountPayload)this.paymentAccountPayload).getBic();
    }

    public List<String> getAcceptedCountryCodes() {
        return ((SepaAccountPayload)this.paymentAccountPayload).getAcceptedCountryCodes();
    }

    public void setAcceptedCountryCodes(List<String> acceptedCountryCodes) {
        ((SepaAccountPayload)this.paymentAccountPayload).setAcceptedCountryCodes(acceptedCountryCodes);
    }

    public void addAcceptedCountry(String countryCode) {
        ((SepaAccountPayload)this.paymentAccountPayload).addAcceptedCountry(countryCode);
    }

    public void removeAcceptedCountry(String countryCode) {
        ((SepaAccountPayload)this.paymentAccountPayload).removeAcceptedCountry(countryCode);
    }

    @Override
    public void onPersistChanges() {
        super.onPersistChanges();
        ((SepaAccountPayload)this.paymentAccountPayload).onPersistChanges();
    }

    @Override
    public void revertChanges() {
        super.revertChanges();
        ((SepaAccountPayload)this.paymentAccountPayload).revertChanges();
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @Nullable
    public List<Country> getSupportedCountries() {
        return CountryUtil.getAllSepaCountries();
    }

    @Override
    public void validateFormField(PaymentAccountForm form, PaymentAccountFormField.FieldId fieldId, String value) {
        switch (fieldId) {
            case IBAN: {
                this.processValidationResult(new SepaIBANValidator().validate(value));
                break;
            }
            default: {
                super.validateFormField(form, fieldId, value);
            }
        }
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        switch (fieldId) {
            case ACCEPTED_COUNTRY_CODES: {
                field.setSupportedSepaEuroCountries(CountryUtil.getAllSepaEuroCountries());
                field.setSupportedSepaNonEuroCountries(CountryUtil.getAllSepaNonEuroCountries());
                break;
            }
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SepaAccount)) {
            return false;
        }
        SepaAccount other = (SepaAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SepaAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

