/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import com.google.common.base.Preconditions;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.Offer;
import haveno.core.payment.BankAccount;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.payment.SepaAccount;
import haveno.core.payment.SepaInstantAccount;
import haveno.core.payment.SpecificBanksAccount;
import haveno.core.payment.payload.PaymentMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReceiptPredicates {
    private static final Logger log = LoggerFactory.getLogger(ReceiptPredicates.class);

    ReceiptPredicates() {
    }

    boolean isEqualPaymentMethods(Offer offer, PaymentAccount account) {
        PaymentMethod accountPaymentMethod = account.getPaymentMethod();
        PaymentMethod offerPaymentMethod = offer.getPaymentMethod();
        boolean arePaymentMethodsEqual = accountPaymentMethod.equals(offerPaymentMethod);
        if (log.isWarnEnabled()) {
            String accountPaymentMethodId = accountPaymentMethod.getId();
            String offerPaymentMethodId = offerPaymentMethod.getId();
            if (!arePaymentMethodsEqual && accountPaymentMethodId.equals(offerPaymentMethodId)) {
                log.warn(PaymentAccountUtil.getInfoForMismatchingPaymentMethodLimits(offer, account));
            }
        }
        return arePaymentMethodsEqual;
    }

    boolean isOfferRequireSameOrSpecificBank(Offer offer, PaymentAccount account) {
        PaymentMethod paymentMethod = offer.getPaymentMethod();
        boolean isSameOrSpecificBank = paymentMethod.equals(PaymentMethod.SAME_BANK) || paymentMethod.equals(PaymentMethod.SPECIFIC_BANKS);
        return account instanceof BankAccount && isSameOrSpecificBank;
    }

    boolean isMatchingBankId(Offer offer, PaymentAccount account) {
        List<String> acceptedBanksForOffer = offer.getAcceptedBankIds();
        Preconditions.checkNotNull(acceptedBanksForOffer, (Object)"offer.getAcceptedBankIds() must not be null");
        String accountBankId = ((BankAccount)((Object)account)).getBankId();
        if (account instanceof SpecificBanksAccount) {
            boolean offerSideMatchesBank = accountBankId != null && acceptedBanksForOffer.contains(accountBankId);
            ArrayList<String> acceptedBanksForAccount = ((SpecificBanksAccount)account).getAcceptedBanks();
            boolean paymentAccountSideMatchesBank = acceptedBanksForAccount.contains(offer.getBankId());
            return offerSideMatchesBank && paymentAccountSideMatchesBank;
        }
        return accountBankId != null && acceptedBanksForOffer.contains(accountBankId);
    }

    boolean isMatchingCountryCodes(Offer offer, PaymentAccount account) {
        List acceptedCodes = Optional.ofNullable(offer.getAcceptedCountryCodes()).orElse(Collections.emptyList());
        String code = Optional.of(account).map(CountryBasedPaymentAccount.class::cast).map(CountryBasedPaymentAccount::getCountry).map(country -> country.code).orElse("undefined");
        return acceptedCodes.contains(code);
    }

    boolean isMatchingCurrency(Offer offer, PaymentAccount account) {
        List<TradeCurrency> currencies = account.getTradeCurrencies();
        Set codes = currencies.stream().map(TradeCurrency::getCode).collect(Collectors.toSet());
        return codes.contains(offer.getCounterCurrencyCode());
    }

    boolean isMatchingSepaOffer(Offer offer, PaymentAccount account) {
        boolean isSepa = account instanceof SepaAccount;
        boolean isSepaInstant = account instanceof SepaInstantAccount;
        return offer.getPaymentMethod().equals(PaymentMethod.SEPA) && (isSepa || isSepaInstant);
    }

    boolean isMatchingSepaInstant(Offer offer, PaymentAccount account) {
        return offer.getPaymentMethod().equals(PaymentMethod.SEPA_INSTANT) && account instanceof SepaInstantAccount;
    }
}

