/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.PixAccountPayload;
import java.util.List;
import lombok.NonNull;

public final class PixAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("BRL"));

    public PixAccount() {
        super(PaymentMethod.PIX);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new PixAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setPixKey(String pixKey) {
        ((PixAccountPayload)this.paymentAccountPayload).setPixKey(pixKey);
    }

    public String getPixKey() {
        return ((PixAccountPayload)this.paymentAccountPayload).getPixKey();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.pix.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.pix.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.pix.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PixAccount)) {
            return false;
        }
        PixAccount other = (PixAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PixAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

