/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.offer.Offer;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PaymentAccounts {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccounts.class);
    private final Set<PaymentAccount> accounts;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final BiPredicate<Offer, PaymentAccount> validator;

    PaymentAccounts(Set<PaymentAccount> accounts, AccountAgeWitnessService accountAgeWitnessService) {
        this(accounts, accountAgeWitnessService, PaymentAccountUtil::isPaymentAccountValidForOffer);
    }

    PaymentAccounts(Set<PaymentAccount> accounts, AccountAgeWitnessService accountAgeWitnessService, BiPredicate<Offer, PaymentAccount> validator) {
        this.accounts = accounts;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.validator = validator;
    }

    @Nullable
    PaymentAccount getOldestPaymentAccountForOffer(Offer offer) {
        List<PaymentAccount> sortedValidAccounts = this.sortValidAccounts(offer);
        this.logAccounts(sortedValidAccounts);
        return this.firstOrNull(sortedValidAccounts);
    }

    private List<PaymentAccount> sortValidAccounts(Offer offer) {
        Comparator comparator = this::compareByTradeLimit;
        return this.accounts.stream().filter(account -> this.validator.test(offer, (PaymentAccount)account)).sorted(comparator.reversed()).collect(Collectors.toList());
    }

    @Nullable
    private PaymentAccount firstOrNull(List<PaymentAccount> accounts) {
        return accounts.isEmpty() ? null : accounts.get(0);
    }

    private void logAccounts(List<PaymentAccount> accounts) {
        if (log.isDebugEnabled()) {
            StringBuilder message = new StringBuilder("Valid accounts: \n");
            for (PaymentAccount account : accounts) {
                String accountName = account.getAccountName();
                String witnessHex = this.accountAgeWitnessService.getMyWitnessHashAsHex(account.getPaymentAccountPayload());
                message.append("name = ").append(accountName).append("; witness hex = ").append(witnessHex).append(";\n");
            }
            log.debug(message.toString());
        }
    }

    private int compareByTradeLimit(PaymentAccount left, PaymentAccount right) {
        if (this.accountAgeWitnessService.myHasTradeLimitException(left)) {
            return !this.accountAgeWitnessService.myHasTradeLimitException(right) ? 1 : 0;
        }
        if (this.accountAgeWitnessService.myHasTradeLimitException(right)) {
            return -1;
        }
        AccountAgeWitness leftWitness = this.accountAgeWitnessService.getMyWitness(left.getPaymentAccountPayload());
        AccountAgeWitness rightWitness = this.accountAgeWitnessService.getMyWitness(right.getPaymentAccountPayload());
        Date now = new Date();
        long leftSignAge = this.accountAgeWitnessService.getWitnessSignAge(leftWitness, now);
        long rightSignAge = this.accountAgeWitnessService.getWitnessSignAge(rightWitness, now);
        return Long.compare(leftSignAge, rightSignAge);
    }
}

