/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.Utilities;
import haveno.core.api.model.PaymentAccountForm;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.BankUtil;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.PaymentAccountFactory;
import haveno.core.payment.PaymentAccountTypeAdapter;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.validation.AccountNrValidator;
import haveno.core.payment.validation.BICValidator;
import haveno.core.payment.validation.BranchIdValidator;
import haveno.core.payment.validation.EmailOrMobileNrValidator;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.payment.validation.IBANValidator;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.validation.InputValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccount;
import protobuf.TradeCurrency;

public abstract class PaymentAccount
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccount.class);
    protected final PaymentMethod paymentMethod;
    protected String id;
    protected long creationDate;
    public PaymentAccountPayload paymentAccountPayload;
    protected String accountName;
    protected String persistedAccountName;
    protected final List<haveno.core.locale.TradeCurrency> tradeCurrencies = new ArrayList<haveno.core.locale.TradeCurrency>();
    @Nullable
    protected haveno.core.locale.TradeCurrency selectedTradeCurrency;
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().serializeNulls();
    private static final Predicate<String> isCommaDelimitedCurrencyList = s -> s != null && s.contains(",");
    public static final Function<String, List<String>> commaDelimitedCodesToList = s -> {
        if (isCommaDelimitedCurrencyList.test((String)s)) {
            return Arrays.stream(s.split(",")).map(a -> a.trim().toUpperCase()).collect(Collectors.toList());
        }
        if (s != null && !s.isEmpty()) {
            return Collections.singletonList(s.trim().toUpperCase());
        }
        return new ArrayList();
    };

    protected PaymentAccount(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void init() {
        this.id = UUID.randomUUID().toString();
        this.creationDate = new Date().getTime();
        this.paymentAccountPayload = this.createPayload();
    }

    public void init(PaymentAccountPayload payload) {
        this.id = payload.getId();
        this.creationDate = new Date().getTime();
        this.paymentAccountPayload = payload;
    }

    public boolean isFiat() {
        return this.getSingleTradeCurrency() == null || CurrencyUtil.isFiatCurrency(this.getSingleTradeCurrency().getCode());
    }

    public boolean isCryptoCurrency() {
        return this.getSingleTradeCurrency() != null && CurrencyUtil.isCryptoCurrency(this.getSingleTradeCurrency().getCode());
    }

    public protobuf.PaymentAccount toProtoMessage() {
        Preconditions.checkNotNull((Object)this.accountName, (Object)"accountName must not be null");
        PaymentAccount.Builder builder = protobuf.PaymentAccount.newBuilder().setPaymentMethod(this.paymentMethod.toProtoMessage()).setId(this.id).setCreationDate(this.creationDate).setPaymentAccountPayload((protobuf.PaymentAccountPayload)this.paymentAccountPayload.toProtoMessage()).setAccountName(this.accountName).addAllTradeCurrencies(ProtoUtil.collectionToProto(this.tradeCurrencies, TradeCurrency.class));
        Optional.ofNullable(this.selectedTradeCurrency).ifPresent(selectedTradeCurrency -> builder.setSelectedTradeCurrency((TradeCurrency)selectedTradeCurrency.toProtoMessage()));
        return builder.build();
    }

    public protobuf.PaymentAccount toProtoMessage(protobuf.PaymentAccountPayload paymentAccountPayload) {
        Preconditions.checkNotNull((Object)this.accountName, (Object)"accountName must not be null");
        PaymentAccount.Builder builder = protobuf.PaymentAccount.newBuilder().setPaymentMethod(this.paymentMethod.toProtoMessage()).setId(this.id).setCreationDate(this.creationDate).setPaymentAccountPayload(paymentAccountPayload).setAccountName(this.accountName).addAllTradeCurrencies(ProtoUtil.collectionToProto(this.tradeCurrencies, TradeCurrency.class));
        Optional.ofNullable(this.selectedTradeCurrency).ifPresent(selectedTradeCurrency -> builder.setSelectedTradeCurrency((TradeCurrency)selectedTradeCurrency.toProtoMessage()));
        return builder.build();
    }

    public static PaymentAccount fromProto(protobuf.PaymentAccount proto, CoreProtoResolver coreProtoResolver) {
        String paymentMethodId = proto.getPaymentMethod().getId();
        List tradeCurrencies = proto.getTradeCurrenciesList().stream().map(haveno.core.locale.TradeCurrency::fromProto).collect(Collectors.toList());
        Optional<haveno.core.locale.TradeCurrency> ngnTwOptional = tradeCurrencies.stream().filter(e -> paymentMethodId.equals("TRANSFERWISE")).filter(e -> e.getCode().equals("NGN")).findAny();
        ngnTwOptional.ifPresent(tradeCurrencies::remove);
        try {
            PaymentAccount account = PaymentAccountFactory.getPaymentAccount(PaymentMethod.getPaymentMethodOrNA(paymentMethodId));
            account.getTradeCurrencies().clear();
            account.setId(proto.getId());
            account.setCreationDate(proto.getCreationDate());
            account.setAccountName(proto.getAccountName());
            account.setPersistedAccountName(proto.getAccountName());
            account.getTradeCurrencies().addAll(tradeCurrencies);
            account.setPaymentAccountPayload(coreProtoResolver.fromProto(proto.getPaymentAccountPayload()));
            if (proto.hasSelectedTradeCurrency()) {
                account.setSelectedTradeCurrency(haveno.core.locale.TradeCurrency.fromProto(proto.getSelectedTradeCurrency()));
            }
            return account;
        }
        catch (RuntimeException e2) {
            log.warn("Could not load account: {}, exception: {}", (Object)paymentMethodId, (Object)e2.toString());
            return null;
        }
    }

    public Date getCreationDate() {
        return new Date(this.creationDate);
    }

    public void addCurrency(haveno.core.locale.TradeCurrency tradeCurrency) {
        if (!this.tradeCurrencies.contains(tradeCurrency)) {
            this.tradeCurrencies.add(tradeCurrency);
        }
    }

    public void removeCurrency(haveno.core.locale.TradeCurrency tradeCurrency) {
        this.tradeCurrencies.remove(tradeCurrency);
    }

    public boolean hasMultipleCurrencies() {
        return this.tradeCurrencies.size() > 1;
    }

    public void setSingleTradeCurrency(haveno.core.locale.TradeCurrency tradeCurrency) {
        this.tradeCurrencies.clear();
        this.tradeCurrencies.add(tradeCurrency);
        this.setSelectedTradeCurrency(tradeCurrency);
    }

    @Nullable
    public haveno.core.locale.TradeCurrency getSingleTradeCurrency() {
        if (this.tradeCurrencies.size() == 1) {
            return this.tradeCurrencies.get(0);
        }
        return null;
    }

    public long getMaxTradePeriod() {
        return this.paymentMethod.getMaxTradePeriod();
    }

    protected abstract PaymentAccountPayload createPayload();

    public void setSalt(byte[] salt) {
        this.paymentAccountPayload.setSalt(salt);
    }

    public byte[] getSalt() {
        return this.paymentAccountPayload.getSalt();
    }

    public void setSaltAsHex(String saltAsHex) {
        this.setSalt(Utilities.decodeFromHex((String)saltAsHex));
    }

    public String getSaltAsHex() {
        return Utilities.bytesAsHexString((byte[])this.getSalt());
    }

    public String getOwnerId() {
        return this.paymentAccountPayload.getOwnerId();
    }

    public boolean isCountryBasedPaymentAccount() {
        return this instanceof CountryBasedPaymentAccount;
    }

    public boolean hasPaymentMethodWithId(String paymentMethodId) {
        return this.getPaymentMethod().getId().equals(paymentMethodId);
    }

    public Optional<haveno.core.locale.TradeCurrency> getTradeCurrency() {
        if (this.getSelectedTradeCurrency() != null) {
            return Optional.of(this.getSelectedTradeCurrency());
        }
        if (this.getSingleTradeCurrency() != null) {
            return Optional.of(this.getSingleTradeCurrency());
        }
        if (!this.getTradeCurrencies().isEmpty()) {
            return Optional.of(this.getTradeCurrencies().get(0));
        }
        return Optional.empty();
    }

    public void onAddToUser() {
    }

    public String getPreTradeMessage(boolean isBuyer) {
        if (isBuyer) {
            return this.getMessageForBuyer();
        }
        return this.getMessageForSeller();
    }

    public String getMessageForBuyer() {
        return null;
    }

    public String getMessageForSeller() {
        return null;
    }

    public String getMessageForAccountCreation() {
        return null;
    }

    public void onPersistChanges() {
        this.setPersistedAccountName(this.getAccountName());
    }

    public void revertChanges() {
        this.setAccountName(this.getPersistedAccountName());
    }

    @NonNull
    public abstract List<haveno.core.locale.TradeCurrency> getSupportedCurrencies();

    public String toJson() {
        Gson gson = gsonBuilder.create();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        if (this.paymentAccountPayload != null) {
            String payloadJson = this.paymentAccountPayload.toJson();
            Map payloadMap = (Map)gson.fromJson(payloadJson, new TypeToken<Map<String, Object>>(this){}.getType());
            for (Map.Entry entry : payloadMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof List)) continue;
                List list = (List)value;
                String joinedString = list.stream().map(Object::toString).collect(Collectors.joining(","));
                entry.setValue(joinedString);
            }
            jsonMap.putAll(payloadMap);
        }
        jsonMap.put("accountName", this.getAccountName());
        jsonMap.put("accountId", this.getId());
        if (this.paymentAccountPayload != null) {
            jsonMap.put("salt", this.getSaltAsHex());
        }
        return gson.toJson(jsonMap);
    }

    public static synchronized PaymentAccount fromJson(String paymentAccountJsonString) {
        Class<? extends PaymentAccount> clazz = PaymentAccount.getPaymentAccountClassFromJson(paymentAccountJsonString);
        Gson gson = gsonBuilder.registerTypeAdapter(clazz, (Object)new PaymentAccountTypeAdapter(clazz)).create();
        return (PaymentAccount)gson.fromJson(paymentAccountJsonString, clazz);
    }

    private static Class<? extends PaymentAccount> getPaymentAccountClassFromJson(String json) {
        Map jsonMap = (Map)gsonBuilder.create().fromJson(json, Object.class);
        String paymentMethodId = (String)Preconditions.checkNotNull((Object)((String)jsonMap.get("paymentMethodId")), (Object)String.format("cannot not find a paymentMethodId in json string: %s", json));
        return PaymentAccount.getPaymentAccountClass(paymentMethodId);
    }

    private static Class<? extends PaymentAccount> getPaymentAccountClass(String paymentMethodId) {
        PaymentMethod paymentMethod = PaymentMethod.getPaymentMethodOrNA(paymentMethodId);
        return PaymentAccountFactory.getPaymentAccount(paymentMethod).getClass();
    }

    @NonNull
    public abstract List<PaymentAccountFormField.FieldId> getInputFieldIds();

    public PaymentAccountForm toForm() {
        Map jsonMap = (Map)gsonBuilder.create().fromJson(this.toJson(), Object.class);
        PaymentAccountForm form = new PaymentAccountForm(PaymentAccountForm.FormId.valueOf(this.paymentMethod.getId()));
        for (PaymentAccountFormField.FieldId fieldId : this.getInputFieldIds()) {
            PaymentAccountFormField field = this.getEmptyFormField(fieldId);
            field.setValue((String)jsonMap.get(HavenoUtils.toCamelCase(field.getId().toString())));
            form.getFields().add(field);
        }
        return form;
    }

    public void validateFormField(PaymentAccountForm form, PaymentAccountFormField.FieldId fieldId, String value) {
        switch (fieldId) {
            case ACCEPTED_COUNTRY_CODES: {
                List<String> countryCodes = commaDelimitedCodesToList.apply(value);
                List<String> supportedCountryCodes = CountryUtil.getCountryCodes(((CountryBasedPaymentAccount)this).getSupportedCountries());
                for (String countryCode : countryCodes) {
                    if (supportedCountryCodes.contains(countryCode)) continue;
                    throw new IllegalArgumentException("Country is not supported by " + this.getPaymentMethod().getId() + ": " + value);
                }
                break;
            }
            case ACCOUNT_ID: {
                this.processValidationResult(new InputValidator().validate(value));
                break;
            }
            case ACCOUNT_NAME: {
                this.processValidationResult(new LengthValidator(2, 100).validate(value));
                break;
            }
            case ACCOUNT_NR: {
                this.processValidationResult(new AccountNrValidator("GB").validate(value));
                break;
            }
            case ACCOUNT_OWNER: {
                this.processValidationResult(new LengthValidator(2, 100).validate(value));
                break;
            }
            case ACCOUNT_TYPE: {
                this.processValidationResult(new LengthValidator(2, 100).validate(value));
                break;
            }
            case ANSWER: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_ACCOUNT_NAME: {
                this.processValidationResult(new LengthValidator(2, 100).validate(value));
                break;
            }
            case BANK_ACCOUNT_NUMBER: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_ACCOUNT_TYPE: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_ADDRESS: 
            case INTERMEDIARY_ADDRESS: {
                this.processValidationResult(new LengthValidator(1, 100).validate(value));
                break;
            }
            case BANK_BRANCH: 
            case INTERMEDIARY_BRANCH: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case BANK_BRANCH_CODE: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_BRANCH_NAME: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_CODE: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_COUNTRY_CODE: {
                if (CountryUtil.findCountryByCode(value).isPresent()) break;
                throw new IllegalArgumentException("Invalid country code: " + value);
            }
            case BANK_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_NAME: 
            case INTERMEDIARY_NAME: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case BANK_SWIFT_CODE: 
            case INTERMEDIARY_SWIFT_CODE: {
                this.processValidationResult(new LengthValidator(11, 11).validate(value));
                break;
            }
            case BENEFICIARY_ACCOUNT_NR: {
                this.processValidationResult(new LengthValidator(2, 40).validate(value));
                break;
            }
            case BENEFICIARY_ADDRESS: {
                this.processValidationResult(new LengthValidator(1, 100).validate(value));
                break;
            }
            case BENEFICIARY_CITY: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case BENEFICIARY_NAME: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case BENEFICIARY_PHONE: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case BIC: {
                this.processValidationResult(new BICValidator().validate(value));
                break;
            }
            case BRANCH_ID: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case CITY: {
                this.processValidationResult(new LengthValidator(2, 34).validate(value));
                break;
            }
            case CONTACT: {
                this.processValidationResult(new InputValidator().validate(value));
                break;
            }
            case COUNTRY: {
                List<Country> supportedCountries;
                if (this instanceof CountryBasedPaymentAccount && (supportedCountries = ((CountryBasedPaymentAccount)this).getSupportedCountries()) != null && !supportedCountries.isEmpty()) {
                    List<String> supportedCountryCodes = CountryUtil.getCountryCodes(supportedCountries);
                    if (!supportedCountryCodes.contains(value)) {
                        throw new IllegalArgumentException("Country is not supported by " + this.getPaymentMethod().getId() + ": " + value);
                    }
                    return;
                }
                if (CountryUtil.findCountryByCode(value).isPresent()) break;
                throw new IllegalArgumentException("Invalid country code: " + value);
            }
            case EMAIL: {
                this.processValidationResult(new EmailValidator().validate(value));
                break;
            }
            case EMAIL_OR_MOBILE_NR: {
                this.processValidationResult(new EmailOrMobileNrValidator().validate(value));
                break;
            }
            case EXTRA_INFO: {
                break;
            }
            case HOLDER_ADDRESS: {
                this.processValidationResult(new LengthValidator(0, 100).validate(value));
                break;
            }
            case HOLDER_EMAIL: {
                throw new IllegalArgumentException("Not implemented");
            }
            case HOLDER_NAME: {
                this.processValidationResult(new LengthValidator(2, 100).validate(value));
                break;
            }
            case HOLDER_TAX_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case IBAN: {
                this.processValidationResult(new IBANValidator().validate(value));
                break;
            }
            case IFSC: {
                throw new IllegalArgumentException("Not implemented");
            }
            case INTERMEDIARY_COUNTRY_CODE: {
                if (CountryUtil.findCountryByCode(value).isPresent()) break;
                throw new IllegalArgumentException("Invalid country code: " + value);
            }
            case MOBILE_NR: {
                throw new IllegalArgumentException("Not implemented");
            }
            case NATIONAL_ACCOUNT_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case PAYID: {
                this.processValidationResult(new LengthValidator(2, 100).validate(value));
                break;
            }
            case PIX_KEY: {
                throw new IllegalArgumentException("Not implemented");
            }
            case POSTAL_ADDRESS: {
                this.processValidationResult(new InputValidator().validate(value));
                break;
            }
            case PROMPT_PAY_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case QUESTION: {
                throw new IllegalArgumentException("Not implemented");
            }
            case REQUIREMENTS: {
                throw new IllegalArgumentException("Not implemented");
            }
            case SALT: {
                if (value.equals("")) break;
                throw new IllegalArgumentException("Salt must be empty");
            }
            case SORT_CODE: {
                this.processValidationResult(new BranchIdValidator("GB").validate(value));
                break;
            }
            case SPECIAL_INSTRUCTIONS: {
                break;
            }
            case STATE: {
                String countryCode = form.getValue(PaymentAccountFormField.FieldId.COUNTRY);
                boolean isStateRequired = BankUtil.isStateRequired(countryCode);
                if (value == null || value.isEmpty()) {
                    if (!isStateRequired) break;
                    throw new IllegalArgumentException("Must provide state for country " + countryCode);
                }
                if (isStateRequired) break;
                throw new IllegalArgumentException("Must not provide state for country " + countryCode);
            }
            case TRADE_CURRENCIES: {
                this.processValidationResult(new InputValidator().validate(value));
                List<String> currencyCodes = commaDelimitedCodesToList.apply(value);
                Optional<List<haveno.core.locale.TradeCurrency>> tradeCurrencies = CurrencyUtil.getTradeCurrenciesInList(currencyCodes, this.getSupportedCurrencies());
                if (tradeCurrencies.isPresent()) break;
                throw new IllegalArgumentException("No trade currencies were found in the " + this.getPaymentMethod().getDisplayString() + " account form");
            }
            case USERNAME: {
                this.processValidationResult(new LengthValidator(3, 100).validate(value));
                break;
            }
            case EMAIL_OR_MOBILE_NR_OR_USERNAME: {
                this.processValidationResult(new LengthValidator(3, 100).validate(value));
                break;
            }
            case EMAIL_OR_MOBILE_NR_OR_CASHTAG: {
                this.processValidationResult(new LengthValidator(3, 100).validate(value));
                break;
            }
            case ADDRESS: {
                this.processValidationResult(new LengthValidator(10, 150).validate(value));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled form field: " + String.valueOf((Object)fieldId));
            }
        }
    }

    protected void processValidationResult(InputValidator.ValidationResult result) {
        if (!result.isValid) {
            throw new IllegalArgumentException(result.errorMessage);
        }
    }

    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = new PaymentAccountFormField(fieldId);
        switch (fieldId) {
            case ACCEPTED_COUNTRY_CODES: {
                field.setComponent(PaymentAccountFormField.Component.SELECT_MULTIPLE);
                field.setLabel(Res.get("payment.accepted.countries"));
                field.setSupportedCountries(((CountryBasedPaymentAccount)this).getSupportedCountries());
                break;
            }
            case ACCOUNT_ID: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.uphold.accountId"));
                break;
            }
            case ACCOUNT_NAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.name"));
                field.setMinLength(3);
                field.setMaxLength(100);
                break;
            }
            case ACCOUNT_NR: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.accountNr"));
                break;
            }
            case ACCOUNT_OWNER: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.owner"));
                break;
            }
            case ACCOUNT_TYPE: {
                field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
                field.setLabel(Res.get("payment.select.account"));
                break;
            }
            case ANSWER: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.answer"));
                break;
            }
            case BANK_ACCOUNT_NAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.owner"));
                field.setMinLength(2);
                field.setMaxLength(100);
                break;
            }
            case BANK_ACCOUNT_NUMBER: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_ACCOUNT_TYPE: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_ADDRESS: {
                field.setComponent(PaymentAccountFormField.Component.TEXTAREA);
                field.setLabel(Res.get("payment.swift.address.bank"));
                break;
            }
            case BANK_BRANCH: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.branch.bank"));
                break;
            }
            case BANK_BRANCH_CODE: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.swiftCode.bank"));
                break;
            }
            case BANK_BRANCH_NAME: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_CODE: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_COUNTRY_CODE: {
                field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
                field.setLabel(Res.get("payment.bank.country"));
                break;
            }
            case BANK_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case BANK_NAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.name.bank"));
                break;
            }
            case BANK_SWIFT_CODE: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.swiftCode.bank"));
                break;
            }
            case BENEFICIARY_ACCOUNT_NR: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.account"));
                break;
            }
            case BENEFICIARY_ADDRESS: {
                field.setComponent(PaymentAccountFormField.Component.TEXTAREA);
                field.setLabel(Res.get("payment.swift.address.beneficiary"));
                break;
            }
            case BENEFICIARY_CITY: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.city"));
                break;
            }
            case BENEFICIARY_NAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.owner"));
                break;
            }
            case BENEFICIARY_PHONE: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.phone.beneficiary"));
                break;
            }
            case BIC: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel("BIC");
                break;
            }
            case BRANCH_ID: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                break;
            }
            case CITY: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.city"));
            }
            case CONTACT: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.payByMail.contact"));
            }
            case COUNTRY: {
                field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
                field.setLabel(Res.get("shared.country"));
                if (!(this instanceof CountryBasedPaymentAccount)) break;
                field.setSupportedCountries(((CountryBasedPaymentAccount)this).getSupportedCountries());
                break;
            }
            case EMAIL: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setType("email");
                field.setLabel(Res.get("payment.email"));
                break;
            }
            case EMAIL_OR_MOBILE_NR: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.email.mobile"));
                break;
            }
            case EXTRA_INFO: {
                field.setComponent(PaymentAccountFormField.Component.TEXTAREA);
                field.setLabel(Res.get("payment.shared.optionalExtra"));
                break;
            }
            case HOLDER_ADDRESS: {
                field.setComponent(PaymentAccountFormField.Component.TEXTAREA);
                field.setLabel(Res.get("payment.account.owner.address"));
                break;
            }
            case HOLDER_EMAIL: {
                throw new IllegalArgumentException("Not implemented");
            }
            case HOLDER_NAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.owner"));
                field.setMinLength(2);
                field.setMaxLength(100);
                break;
            }
            case HOLDER_TAX_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case IBAN: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel("IBAN");
                break;
            }
            case IFSC: {
                throw new IllegalArgumentException("Not implemented");
            }
            case INTERMEDIARY_ADDRESS: {
                field.setComponent(PaymentAccountFormField.Component.TEXTAREA);
                field.setLabel(Res.get("payment.swift.address.intermediary"));
                break;
            }
            case INTERMEDIARY_BRANCH: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.branch.intermediary"));
                break;
            }
            case INTERMEDIARY_COUNTRY_CODE: {
                field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
                field.setLabel(Res.get("payment.swift.country.intermediary"));
                break;
            }
            case INTERMEDIARY_NAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.name.intermediary"));
                break;
            }
            case INTERMEDIARY_SWIFT_CODE: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.swift.swiftCode.intermediary"));
                break;
            }
            case MOBILE_NR: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.mobile"));
                break;
            }
            case NATIONAL_ACCOUNT_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case PAYID: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.email.mobile"));
                break;
            }
            case PIX_KEY: {
                throw new IllegalArgumentException("Not implemented");
            }
            case POSTAL_ADDRESS: {
                field.setComponent(PaymentAccountFormField.Component.TEXTAREA);
                field.setLabel(Res.get("payment.postal.address"));
                break;
            }
            case PROMPT_PAY_ID: {
                throw new IllegalArgumentException("Not implemented");
            }
            case QUESTION: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.secret"));
                break;
            }
            case REQUIREMENTS: {
                throw new IllegalArgumentException("Not implemented");
            }
            case SALT: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel("Salt");
                break;
            }
            case SORT_CODE: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.fasterPayments.ukSortCode"));
                break;
            }
            case SPECIAL_INSTRUCTIONS: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.shared.extraInfo"));
                break;
            }
            case STATE: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.state"));
                field.setRequiredForCountries(CountryUtil.getCountryCodes(BankUtil.getAllStateRequiredCountries()));
                break;
            }
            case TRADE_CURRENCIES: {
                field.setComponent(PaymentAccountFormField.Component.SELECT_MULTIPLE);
                field.setLabel(Res.get("payment.supportedCurrencies"));
                field.setSupportedCurrencies(this.getSupportedCurrencies());
                field.setValue(String.join((CharSequence)",", this.getSupportedCurrencies().stream().map(haveno.core.locale.TradeCurrency::getCode).collect(Collectors.toList())));
                break;
            }
            case USERNAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.username"));
                field.setMinLength(3);
                field.setMaxLength(100);
                break;
            }
            case EMAIL_OR_MOBILE_NR_OR_USERNAME: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.email.mobile.username"));
                field.setMinLength(3);
                field.setMaxLength(100);
                break;
            }
            case EMAIL_OR_MOBILE_NR_OR_CASHTAG: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.email.mobile.cashtag"));
                field.setMinLength(3);
                field.setMaxLength(100);
                break;
            }
            case ADDRESS: {
                field.setComponent(PaymentAccountFormField.Component.TEXT);
                field.setLabel(Res.get("payment.account.address"));
                field.setMinLength(10);
                field.setMaxLength(150);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled form field: " + String.valueOf(field));
            }
        }
        if ("".equals(field.getValue())) {
            field.setValue("");
        }
        return field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentAccount)) {
            return false;
        }
        PaymentAccount other = (PaymentAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$creationDate = this.getCreationDate();
        Date other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        PaymentMethod this$paymentMethod = this.getPaymentMethod();
        PaymentMethod other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !((Object)this$paymentMethod).equals(other$paymentMethod)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PaymentAccountPayload this$paymentAccountPayload = this.getPaymentAccountPayload();
        PaymentAccountPayload other$paymentAccountPayload = other.getPaymentAccountPayload();
        if (this$paymentAccountPayload == null ? other$paymentAccountPayload != null : !((Object)this$paymentAccountPayload).equals(other$paymentAccountPayload)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        List<haveno.core.locale.TradeCurrency> this$tradeCurrencies = this.getTradeCurrencies();
        List<haveno.core.locale.TradeCurrency> other$tradeCurrencies = other.getTradeCurrencies();
        if (this$tradeCurrencies == null ? other$tradeCurrencies != null : !((Object)this$tradeCurrencies).equals(other$tradeCurrencies)) {
            return false;
        }
        haveno.core.locale.TradeCurrency this$selectedTradeCurrency = this.getSelectedTradeCurrency();
        haveno.core.locale.TradeCurrency other$selectedTradeCurrency = other.getSelectedTradeCurrency();
        return !(this$selectedTradeCurrency == null ? other$selectedTradeCurrency != null : !((Object)this$selectedTradeCurrency).equals(other$selectedTradeCurrency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        PaymentMethod $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : ((Object)$paymentMethod).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PaymentAccountPayload $paymentAccountPayload = this.getPaymentAccountPayload();
        result = result * 59 + ($paymentAccountPayload == null ? 43 : ((Object)$paymentAccountPayload).hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        List<haveno.core.locale.TradeCurrency> $tradeCurrencies = this.getTradeCurrencies();
        result = result * 59 + ($tradeCurrencies == null ? 43 : ((Object)$tradeCurrencies).hashCode());
        haveno.core.locale.TradeCurrency $selectedTradeCurrency = this.getSelectedTradeCurrency();
        result = result * 59 + ($selectedTradeCurrency == null ? 43 : ((Object)$selectedTradeCurrency).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentAccount(paymentMethod=" + String.valueOf(this.getPaymentMethod()) + ", id=" + this.getId() + ", creationDate=" + String.valueOf(this.getCreationDate()) + ", paymentAccountPayload=" + String.valueOf(this.getPaymentAccountPayload()) + ", accountName=" + this.getAccountName() + ", persistedAccountName=" + this.getPersistedAccountName() + ", tradeCurrencies=" + String.valueOf(this.getTradeCurrencies()) + ", selectedTradeCurrency=" + String.valueOf(this.getSelectedTradeCurrency()) + ")";
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getId() {
        return this.id;
    }

    public PaymentAccountPayload getPaymentAccountPayload() {
        return this.paymentAccountPayload;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getPersistedAccountName() {
        return this.persistedAccountName;
    }

    public List<haveno.core.locale.TradeCurrency> getTradeCurrencies() {
        return this.tradeCurrencies;
    }

    @Nullable
    public haveno.core.locale.TradeCurrency getSelectedTradeCurrency() {
        return this.selectedTradeCurrency;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void setPaymentAccountPayload(PaymentAccountPayload paymentAccountPayload) {
        this.paymentAccountPayload = paymentAccountPayload;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setPersistedAccountName(String persistedAccountName) {
        this.persistedAccountName = persistedAccountName;
    }

    public void setSelectedTradeCurrency(@Nullable haveno.core.locale.TradeCurrency selectedTradeCurrency) {
        this.selectedTradeCurrency = selectedTradeCurrency;
    }
}

