/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PayPalAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class PayPalAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AUD"), new TraditionalCurrency("BRL"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CNY"), new TraditionalCurrency("CZK"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EUR"), new TraditionalCurrency("HKD"), new TraditionalCurrency("HUF"), new TraditionalCurrency("ILS"), new TraditionalCurrency("JPY"), new TraditionalCurrency("MYR"), new TraditionalCurrency("MXN"), new TraditionalCurrency("TWD"), new TraditionalCurrency("NZD"), new TraditionalCurrency("NOK"), new TraditionalCurrency("PHP"), new TraditionalCurrency("PLN"), new TraditionalCurrency("GBP"), new TraditionalCurrency("SGD"), new TraditionalCurrency("SEK"), new TraditionalCurrency("CHF"), new TraditionalCurrency("THB"), new TraditionalCurrency("USD"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.EMAIL_OR_MOBILE_NR_OR_USERNAME, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.EXTRA_INFO, PaymentAccountFormField.FieldId.SALT);

    public PayPalAccount() {
        super(PaymentMethod.PAYPAL);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new PayPalAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setEmailOrMobileNrOrUsername(String emailOrMobileNrOrUsername) {
        ((PayPalAccountPayload)this.paymentAccountPayload).setEmailOrMobileNrOrUsername(emailOrMobileNrOrUsername);
    }

    public String getEmailOrMobileNrOrUsername() {
        return ((PayPalAccountPayload)this.paymentAccountPayload).getEmailOrMobileNrOrUsername();
    }

    public void setExtraInfo(String extraInfo) {
        ((PayPalAccountPayload)this.paymentAccountPayload).setExtraInfo(extraInfo);
    }

    public String getExtraInfo() {
        return ((PayPalAccountPayload)this.paymentAccountPayload).getExtraInfo();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayPalAccount)) {
            return false;
        }
        PayPalAccount other = (PayPalAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayPalAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

