/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.NequiAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class NequiAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("COP"));

    public NequiAccount() {
        super(PaymentMethod.NEQUI);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new NequiAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setMobileNr(String mobileNr) {
        ((NequiAccountPayload)this.paymentAccountPayload).setMobileNr(mobileNr);
    }

    public String getMobileNr() {
        return ((NequiAccountPayload)this.paymentAccountPayload).getMobileNr();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.nequi.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.nequi.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.nequi.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NequiAccount)) {
            return false;
        }
        NequiAccount other = (NequiAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NequiAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

