/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.MoneseAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class MoneseAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("RON"));

    public MoneseAccount() {
        super(PaymentMethod.MONESE);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new MoneseAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setHolderName(String accountId) {
        ((MoneseAccountPayload)this.paymentAccountPayload).setHolderName(accountId);
    }

    public String getHolderName() {
        return ((MoneseAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setMobileNr(String accountId) {
        ((MoneseAccountPayload)this.paymentAccountPayload).setMobileNr(accountId);
    }

    public String getMobileNr() {
        return ((MoneseAccountPayload)this.paymentAccountPayload).getMobileNr();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.monese.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.monese.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.monese.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoneseAccount)) {
            return false;
        }
        MoneseAccount other = (MoneseAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MoneseAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

