/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import com.google.common.collect.ImmutableMap;
import haveno.core.trade.HavenoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JapanBankData {
    private static final Map<String, String> megaBanksEnglish = ImmutableMap.builder().put((Object)"9900", (Object)"Japan Post Bank Yucho").put((Object)"0001", (Object)"Mizuho Bank").put((Object)"0005", (Object)"Mitsubishi UFJ Bank (MUFG)").put((Object)"0009", (Object)"Sumitomo Mitsui Banking Corporation (SMBC)").put((Object)"0010", (Object)"Resona Bank").put((Object)"0033", (Object)"Japan Net Bank").put((Object)"0034", (Object)"Seven Bank (7-11)").put((Object)"0035", (Object)"Sony Bank").put((Object)"0036", (Object)"Rakuten Bank").put((Object)"0038", (Object)"SBI Sumishin Net Bank").put((Object)"0039", (Object)"Jibun Bank").put((Object)"0040", (Object)"Aeon Bank").put((Object)"0042", (Object)"Lawson Bank").put((Object)"0150", (Object)"Suruga Bank").put((Object)"0288", (Object)"Mitsubishi UFJ Trust Bank").put((Object)"0289", (Object)"Mizuho Trust Bank").put((Object)"0294", (Object)"Sumitomo Trust Bank").put((Object)"0300", (Object)"SMBC Trust Bank (PRESTIA)").put((Object)"0304", (Object)"Nomura Trust Bank").put((Object)"0307", (Object)"Orix Trust Bank").put((Object)"0310", (Object)"GMO Aozora Net Bank").put((Object)"0321", (Object)"Japan Securities Trust Bank").put((Object)"0397", (Object)"Shinsei Bank").put((Object)"0398", (Object)"Aozora Bank").put((Object)"0402", (Object)"JP Morgan Chase Bank").put((Object)"0442", (Object)"BNY Mellon").put((Object)"0458", (Object)"DBS Bank").put((Object)"0472", (Object)"SBJ Shinhan Bank Japan").build();
    private static final Map<String, String> majorBanksJapanese = ImmutableMap.builder().put((Object)"9900", (Object)"\u3086\u3046\u3061\u3087\u9280\u884c").put((Object)"0001", (Object)"\u307f\u305a\u307b\u9280\u884c").put((Object)"0005", (Object)"\u4e09\u83f1\uff35\uff26\uff2a\u9280\u884c").put((Object)"0009", (Object)"\u4e09\u4e95\u4f4f\u53cb\u9280\u884c").put((Object)"0010", (Object)"\u308a\u305d\u306a\u9280\u884c").put((Object)"0017", (Object)"\u57fc\u7389\u308a\u305d\u306a\u9280\u884c").put((Object)"0033", (Object)"\u30b8\u30e3\u30d1\u30f3\u30cd\u30c3\u30c8\u9280\u884c").put((Object)"0034", (Object)"\u30bb\u30d6\u30f3\u9280\u884c").put((Object)"0035", (Object)"\u30bd\u30cb\u30fc\u9280\u884c").put((Object)"0036", (Object)"\u697d\u5929\u9280\u884c").put((Object)"0038", (Object)"\u4f4f\u4fe1\uff33\uff22\uff29\u30cd\u30c3\u30c8\u9280\u884c").put((Object)"0039", (Object)"\u3058\u3076\u3093\u9280\u884c").put((Object)"0040", (Object)"\u30a4\u30aa\u30f3\u9280\u884c").put((Object)"0041", (Object)"\u5927\u548c\u30cd\u30af\u30b9\u30c8\u9280\u884c").put((Object)"0042", (Object)"\u30ed\u30fc\u30bd\u30f3\u9280\u884c").put((Object)"0051", (Object)"\u5168\u9280\u5354").put((Object)"0052", (Object)"\u6a2a\u6d5c\u9280\u884c\u5354\u4f1a").put((Object)"0053", (Object)"\u91e7\u8def\u9280\u884c\u5354\u4f1a").put((Object)"0054", (Object)"\u672d\u5e4c\u9280\u884c\u5354\u4f1a").put((Object)"0056", (Object)"\u51fd\u9928\u9280\u884c\u5354\u4f1a").put((Object)"0057", (Object)"\u9752\u68ee\u9280\u884c\u5354\u4f1a").put((Object)"0058", (Object)"\u79cb\u7530\u9280\u884c\u5354\u4f1a").put((Object)"0059", (Object)"\u5bae\u57ce\u9280\u884c\u5354\u4f1a").put((Object)"0060", (Object)"\u798f\u5cf6\u9280\u884c\u5354\u4f1a").put((Object)"0061", (Object)"\u7fa4\u99ac\u9280\u884c\u5354\u4f1a").put((Object)"0062", (Object)"\u65b0\u6f5f\u9280\u884c\u5354\u4f1a").put((Object)"0063", (Object)"\u77f3\u5ddd\u9280\u884c\u5354\u4f1a").put((Object)"0064", (Object)"\u5c71\u68a8\u9280\u884c\u5354\u4f1a").put((Object)"0065", (Object)"\u9577\u91ce\u9280\u884c\u5354\u4f1a").put((Object)"0066", (Object)"\u9759\u5ca1\u9280\u884c\u5354\u4f1a").put((Object)"0067", (Object)"\u540d\u53e4\u5c4b\u9280\u884c\u5354\u4f1a").put((Object)"0068", (Object)"\u4eac\u90fd\u9280\u884c\u5354\u4f1a").put((Object)"0069", (Object)"\u5927\u962a\u9280\u884c\u5354\u4f1a").put((Object)"0070", (Object)"\u795e\u6238\u9280\u884c\u5354\u4f1a").put((Object)"0071", (Object)"\u5ca1\u5c71\u9280\u884c\u5354\u4f1a").put((Object)"0072", (Object)"\u5e83\u5cf6\u9280\u884c\u5354\u4f1a").put((Object)"0073", (Object)"\u5cf6\u6839\u9280\u884c\u5354\u4f1a").put((Object)"0074", (Object)"\u5c71\u53e3\u9280\u884c\u5354\u4f1a").put((Object)"0075", (Object)"\u9999\u5ddd\u9280\u884c\u5354\u4f1a").put((Object)"0076", (Object)"\u611b\u5a9b\u9280\u884c\u5354\u4f1a").put((Object)"0077", (Object)"\u9ad8\u77e5\u9280\u884c\u5354\u4f1a").put((Object)"0078", (Object)"\u5317\u4e5d\u5dde\u9280\u884c\u5354\u4f1a").put((Object)"0079", (Object)"\u798f\u5ca1\u9280\u884c\u5354\u4f1a").put((Object)"0080", (Object)"\u5927\u5206\u9280\u884c\u5354\u4f1a").put((Object)"0081", (Object)"\u9577\u5d0e\u9280\u884c\u5354\u4f1a").put((Object)"0082", (Object)"\u718a\u672c\u9280\u884c\u5354\u4f1a").put((Object)"0083", (Object)"\u9e7f\u5150\u5cf6\u9280\u884c\u5354\u4f1a").put((Object)"0084", (Object)"\u6c96\u7e04\u9280\u884c\u5354\u4f1a").put((Object)"0090", (Object)"\u5168\u9280\u30cd\u30c3\u30c8").put((Object)"0095", (Object)"\uff23\uff2c\uff33\uff22\uff21\uff2e\uff2b").put((Object)"0116", (Object)"\u5317\u6d77\u9053\u9280\u884c").put((Object)"0117", (Object)"\u9752\u68ee\u9280\u884c").put((Object)"0118", (Object)"\u307f\u3061\u306e\u304f\u9280\u884c").put((Object)"0119", (Object)"\u79cb\u7530\u9280\u884c").put((Object)"0120", (Object)"\u5317\u90fd\u9280\u884c").put((Object)"0121", (Object)"\u8358\u5185\u9280\u884c").put((Object)"0122", (Object)"\u5c71\u5f62\u9280\u884c").put((Object)"0123", (Object)"\u5ca9\u624b\u9280\u884c").put((Object)"0124", (Object)"\u6771\u5317\u9280\u884c").put((Object)"0125", (Object)"\u4e03\u5341\u4e03\u9280\u884c").put((Object)"0126", (Object)"\u6771\u90a6\u9280\u884c").put((Object)"0128", (Object)"\u7fa4\u99ac\u9280\u884c").put((Object)"0129", (Object)"\u8db3\u5229\u9280\u884c").put((Object)"0130", (Object)"\u5e38\u967d\u9280\u884c").put((Object)"0131", (Object)"\u7b51\u6ce2\u9280\u884c").put((Object)"0133", (Object)"\u6b66\u8535\u91ce\u9280\u884c").put((Object)"0134", (Object)"\u5343\u8449\u9280\u884c").put((Object)"0135", (Object)"\u5343\u8449\u8208\u696d\u9280\u884c").put((Object)"0137", (Object)"\u304d\u3089\u307c\u3057\u9280\u884c").put((Object)"0138", (Object)"\u6a2a\u6d5c\u9280\u884c").put((Object)"0140", (Object)"\u7b2c\u56db\u9280\u884c").put((Object)"0141", (Object)"\u5317\u8d8a\u9280\u884c").put((Object)"0142", (Object)"\u5c71\u68a8\u4e2d\u592e\u9280\u884c").put((Object)"0143", (Object)"\u516b\u5341\u4e8c\u9280\u884c").put((Object)"0144", (Object)"\u5317\u9678\u9280\u884c").put((Object)"0145", (Object)"\u5bcc\u5c71\u9280\u884c").put((Object)"0146", (Object)"\u5317\u570b\u9280\u884c").put((Object)"0147", (Object)"\u798f\u4e95\u9280\u884c").put((Object)"0149", (Object)"\u9759\u5ca1\u9280\u884c").put((Object)"0150", (Object)"\u30b9\u30eb\u30ac\u9280\u884c").put((Object)"0151", (Object)"\u6e05\u6c34\u9280\u884c").put((Object)"0152", (Object)"\u5927\u57a3\u5171\u7acb\u9280\u884c").put((Object)"0153", (Object)"\u5341\u516d\u9280\u884c").put((Object)"0154", (Object)"\u4e09\u91cd\u9280\u884c").put((Object)"0155", (Object)"\u767e\u4e94\u9280\u884c").put((Object)"0157", (Object)"\u6ecb\u8cc0\u9280\u884c").put((Object)"0158", (Object)"\u4eac\u90fd\u9280\u884c").put((Object)"0159", (Object)"\u95a2\u897f\u307f\u3089\u3044\u9280\u884c").put((Object)"0161", (Object)"\u6c60\u7530\u6cc9\u5dde\u9280\u884c").put((Object)"0162", (Object)"\u5357\u90fd\u9280\u884c").put((Object)"0163", (Object)"\u7d00\u967d\u9280\u884c").put((Object)"0164", (Object)"\u4f46\u99ac\u9280\u884c").put((Object)"0166", (Object)"\u9ce5\u53d6\u9280\u884c").put((Object)"0167", (Object)"\u5c71\u9670\u5408\u540c\u9280\u884c").put((Object)"0168", (Object)"\u4e2d\u56fd\u9280\u884c").put((Object)"0169", (Object)"\u5e83\u5cf6\u9280\u884c").put((Object)"0170", (Object)"\u5c71\u53e3\u9280\u884c").put((Object)"0172", (Object)"\u963f\u6ce2\u9280\u884c").put((Object)"0173", (Object)"\u767e\u5341\u56db\u9280\u884c").put((Object)"0174", (Object)"\u4f0a\u4e88\u9280\u884c").put((Object)"0175", (Object)"\u56db\u56fd\u9280\u884c").put((Object)"0177", (Object)"\u798f\u5ca1\u9280\u884c").put((Object)"0178", (Object)"\u7b51\u90a6\u9280\u884c").put((Object)"0179", (Object)"\u4f50\u8cc0\u9280\u884c").put((Object)"0180", (Object)"\u5341\u516b\u9280\u884c").put((Object)"0181", (Object)"\u89aa\u548c\u9280\u884c").put((Object)"0182", (Object)"\u80a5\u5f8c\u9280\u884c").put((Object)"0183", (Object)"\u5927\u5206\u9280\u884c").put((Object)"0184", (Object)"\u5bae\u5d0e\u9280\u884c").put((Object)"0185", (Object)"\u9e7f\u5150\u5cf6\u9280\u884c").put((Object)"0187", (Object)"\u7409\u7403\u9280\u884c").put((Object)"0188", (Object)"\u6c96\u7e04\u9280\u884c").put((Object)"0190", (Object)"\u897f\u65e5\u672c\u30b7\u30c6\u30a3\u9280\u884c").put((Object)"0191", (Object)"\u5317\u4e5d\u5dde\u9280\u884c").put((Object)"0288", (Object)"\u4e09\u83f1\uff35\uff26\uff2a\u4fe1\u8a17\u9280\u884c").put((Object)"0289", (Object)"\u307f\u305a\u307b\u4fe1\u8a17\u9280\u884c").put((Object)"0294", (Object)"\u4e09\u4e95\u4f4f\u53cb\u4fe1\u8a17\u9280\u884c").put((Object)"0295", (Object)"\uff22\uff2e\uff39\uff2d\u4fe1\u8a17").put((Object)"0297", (Object)"\u65e5\u672c\u30de\u30b9\u30bf\u30fc\u30c8\u30e9\u30b9\u30c8\u4fe1\u8a17\u9280\u884c").put((Object)"0299", (Object)"\u30b9\u30c6\u30fc\u30c8\u4fe1\u8a17").put((Object)"0300", (Object)"\uff33\uff2d\uff22\uff23\u4fe1\u8a17\u9280\u884c \u30d7\u30ec\u30b9\u30c6\u30a3\u30a2").put((Object)"0304", (Object)"\u91ce\u6751\u4fe1\u8a17\u9280\u884c").put((Object)"0307", (Object)"\u30aa\u30ea\u30c3\u30af\u30b9\u9280\u884c").put((Object)"0310", (Object)"\uff27\uff2d\uff2f\u3042\u304a\u305e\u3089\u30cd\u30c3\u30c8\u9280\u884c").put((Object)"0311", (Object)"\u8fb2\u4e2d\u4fe1\u8a17").put((Object)"0320", (Object)"\u65b0\u751f\u4fe1\u8a17").put((Object)"0321", (Object)"\u65e5\u8a3c\u91d1\u4fe1\u8a17").put((Object)"0324", (Object)"\u65e5\u672c\u30c8\u30e9\u30b9\u30c6\u30a3\u30b5\u30fc\u30d3\u30b9\u4fe1\u8a17\u9280\u884c").put((Object)"0325", (Object)"\u8cc7\u7523\u7ba1\u7406\u30b5\u30fc\u30d3\u30b9\u4fe1\u8a17\u9280\u884c").put((Object)"0397", (Object)"\u65b0\u751f\u9280\u884c").put((Object)"0398", (Object)"\u3042\u304a\u305e\u3089\u9280\u884c").put((Object)"0401", (Object)"\u30b7\u30c6\u30a3\u30d0\u30f3\u30af\u3001\u30a8\u30cc\u30fb\u30a8\u30a4 \u9280\u884c").put((Object)"0402", (Object)"\uff2a\uff30\u30e2\u30eb\u30ac\u30f3\u30fb\u30c1\u30a7\u30fc\u30b9\u9280\u884c").put((Object)"0403", (Object)"\u30a2\u30e1\u30ea\u30ab\u9280\u884c").put((Object)"0411", (Object)"\u9999\u6e2f\u4e0a\u6d77\u9280\u884c").put((Object)"0413", (Object)"\u30b9\u30bf\u30f3\u30c1\u30e4\u30fc\u30c8").put((Object)"0414", (Object)"\u30d0\u30fc\u30af\u30ec\u30a4\u30ba").put((Object)"0421", (Object)"\u30a2\u30b0\u30ea\u30b3\u30eb").put((Object)"0423", (Object)"\u30cf\u30ca").put((Object)"0424", (Object)"\u5370\u5ea6").put((Object)"0425", (Object)"\u5146\u8c50\u570b\u969b\u5546\u9280").put((Object)"0426", (Object)"\u30d0\u30f3\u30b3\u30c4\u30af").put((Object)"0429", (Object)"\u30d0\u30f3\u30af\u30cd\u30ac\u30e9").put((Object)"0430", (Object)"\u30c9\u30a4\u30c4\u9280\u884c").put((Object)"0432", (Object)"\u30d6\u30e9\u30b8\u30eb").put((Object)"0438", (Object)"\u30e6\u30fc\u30aa\u30d0\u30b7\u30fc\u30ba").put((Object)"0439", (Object)"\u30e6\u30fc\u30d3\u30fc\u30a8\u30b9").put((Object)"0442", (Object)"\uff22\uff2e\uff39\u30e1\u30ed\u30f3").put((Object)"0443", (Object)"\u30d3\u30fc\u30fb\u30a8\u30cc\u30fb\u30d4\u30fc\u30fb\u30d1\u30ea\u30d0\u9280\u884c").put((Object)"0444", (Object)"\u30c1\u30e4\u30a4\u30cb\u30fc\u30ba").put((Object)"0445", (Object)"\u30bd\u30b7\u30a8\u30c6").put((Object)"0456", (Object)"\u30e6\u30d0\u30d5").put((Object)"0458", (Object)"\uff24\uff22\uff33").put((Object)"0459", (Object)"\u30d1\u30ad\u30b9\u30bf\u30f3").put((Object)"0460", (Object)"\u30af\u30ec\u30c7\u30a4\u30b9\u30a4\u30b9").put((Object)"0461", (Object)"\u30b3\u30e1\u30eb\u30c4\u9280\u884c").put((Object)"0463", (Object)"\u30a6\u30cb\u30af\u30ec\u30c7\u30a4\u30c8").put((Object)"0468", (Object)"\u30a4\u30f3\u30c9\u30b9\u30c6\u30a4\u30c8").put((Object)"0471", (Object)"\u30ab\u30ca\u30c0\u30ed\u30a4\u30e4\u30eb").put((Object)"0472", (Object)"\uff33\uff22\uff2a\u9280\u884c").put((Object)"0477", (Object)"\u30a6\u30ea\u30a4").put((Object)"0482", (Object)"\u30a2\u30a4\u30a8\u30cc\u30b8\u30fc").put((Object)"0484", (Object)"\u30ca\u30c4\u30c8\u30aa\u30fc\u30b9").put((Object)"0485", (Object)"\u30a2\u30f3\u30ba\u30d0\u30f3\u30af").put((Object)"0487", (Object)"\u30b3\u30e2\u30f3\u30a6\u30a8\u30eb\u30b9").put((Object)"0489", (Object)"\u30d0\u30f3\u30af\u30c1\u30e4\u30a4\u30ca").put((Object)"0495", (Object)"\u30b9\u30c6\u30b9\u30c8\u30ea\u30fc\u30c8").put((Object)"0498", (Object)"\u4e2d\u5c0f\u4f01\u696d").put((Object)"0501", (Object)"\u5317\u6d0b\u9280\u884c").put((Object)"0508", (Object)"\u304d\u3089\u3084\u304b\u9280\u884c").put((Object)"0509", (Object)"\u5317\u65e5\u672c\u9280\u884c").put((Object)"0512", (Object)"\u4ed9\u53f0\u9280\u884c").put((Object)"0513", (Object)"\u798f\u5cf6\u9280\u884c").put((Object)"0514", (Object)"\u5927\u6771\u9280\u884c").put((Object)"0516", (Object)"\u6771\u548c\u9280\u884c").put((Object)"0517", (Object)"\u6803\u6728\u9280\u884c").put((Object)"0522", (Object)"\u4eac\u8449\u9280\u884c").put((Object)"0525", (Object)"\u6771\u65e5\u672c\u9280\u884c").put((Object)"0526", (Object)"\u6771\u4eac\u30b9\u30bf\u30fc\u9280\u884c").put((Object)"0530", (Object)"\u795e\u5948\u5ddd\u9280\u884c").put((Object)"0532", (Object)"\u5927\u5149\u9280\u884c").put((Object)"0533", (Object)"\u9577\u91ce\u9280\u884c").put((Object)"0534", (Object)"\u5bcc\u5c71\u7b2c\u4e00\u9280\u884c").put((Object)"0537", (Object)"\u798f\u90a6\u9280\u884c").put((Object)"0538", (Object)"\u9759\u5ca1\u4e2d\u592e\u9280\u884c").put((Object)"0542", (Object)"\u611b\u77e5\u9280\u884c").put((Object)"0543", (Object)"\u540d\u53e4\u5c4b\u9280\u884c").put((Object)"0544", (Object)"\u4e2d\u4eac\u9280\u884c").put((Object)"0546", (Object)"\u7b2c\u4e09\u9280\u884c").put((Object)"0555", (Object)"\u5927\u6b63\u9280\u884c").put((Object)"0562", (Object)"\u307f\u306a\u3068\u9280\u884c").put((Object)"0565", (Object)"\u5cf6\u6839\u9280\u884c").put((Object)"0566", (Object)"\u30c8\u30de\u30c8\u9280\u884c").put((Object)"0569", (Object)"\u3082\u307f\u3057\u3099\u9280\u884c").put((Object)"0570", (Object)"\u897f\u4eac\u9280\u884c").put((Object)"0572", (Object)"\u5fb3\u5cf6\u9280\u884c").put((Object)"0573", (Object)"\u9999\u5ddd\u9280\u884c").put((Object)"0576", (Object)"\u611b\u5a9b\u9280\u884c").put((Object)"0578", (Object)"\u9ad8\u77e5\u9280\u884c").put((Object)"0582", (Object)"\u798f\u5ca1\u4e2d\u592e\u9280\u884c").put((Object)"0583", (Object)"\u4f50\u8cc0\u5171\u6804\u9280\u884c").put((Object)"0585", (Object)"\u9577\u5d0e\u9280\u884c").put((Object)"0587", (Object)"\u718a\u672c\u9280\u884c").put((Object)"0590", (Object)"\u8c4a\u548c\u9280\u884c").put((Object)"0591", (Object)"\u5bae\u5d0e\u592a\u967d\u9280\u884c").put((Object)"0594", (Object)"\u5357\u65e5\u672c\u9280\u884c").put((Object)"0596", (Object)"\u6c96\u7e04\u6d77\u90a6\u9280\u884c").put((Object)"0603", (Object)"\u97d3\u56fd\u7523\u696d").put((Object)"0607", (Object)"\u5f70\u5316\u5546\u696d").put((Object)"0608", (Object)"\u30a6\u30a8\u30eb\u30ba\u30d5\u30a2\u30b4").put((Object)"0611", (Object)"\u7b2c\u4e00\u5546\u696d").put((Object)"0612", (Object)"\u53f0\u6e7e").put((Object)"0615", (Object)"\u4ea4\u901a").put((Object)"0616", (Object)"\u30e1\u30c8\u30ed\u30dd\u30ea\u30bf\u30f3").put((Object)"0617", (Object)"\u30d5\u30a4\u30ea\u30d4\u30f3").put((Object)"0619", (Object)"\u4e2d\u56fd\u5de5\u5546").put((Object)"0621", (Object)"\u4e2d\u570b\u4fe1\u8a17\u5546\u696d").put((Object)"0623", (Object)"\u30a4\u30f3\u30c6\u30fc\u30b6").put((Object)"0624", (Object)"\u570b\u6c11").put((Object)"0625", (Object)"\u4e2d\u56fd\u5efa\u8a2d").put((Object)"0626", (Object)"\u30a4\u30bf\u30a6\u30a6\u30cb").put((Object)"0627", (Object)"\uff22\uff22\uff36\uff21").put((Object)"0630", (Object)"\u4e2d\u56fd\u8fb2\u696d").put((Object)"0631", (Object)"\u53f0\u65b0").put((Object)"0632", (Object)"\u7389\u5c71").put((Object)"0633", (Object)"\u53f0\u6e7e\u4f01\u9280").put((Object)"0808", (Object)"\u30c9\u30a4\u30c4\u8a3c\u5238").put((Object)"0813", (Object)"\u30bd\u30b7\u30a8\u30c6\u8a3c\u5238").put((Object)"0821", (Object)"\u30d3\u30fc\u30d4\u30fc\u8a3c\u5238").put((Object)"0822", (Object)"\u30d0\u30fc\u30af\u30ec\u30a4\u8a3c\u5238").put((Object)"0831", (Object)"\u30a2\u30b0\u30ea\u30b3\u30eb\u8a3c\u5238").put((Object)"0832", (Object)"\u30b8\u30a8\u30a4\u30d4\u30fc\u8a3c\u5238").put((Object)"0842", (Object)"\u30b4\u30eb\u30c9\u30de\u30f3\u8a3c\u5238").put((Object)"0845", (Object)"\u30ca\u30c4\u30c8\u30a6\u30a8\u8a3c\u5238").put((Object)"0900", (Object)"\u65e5\u672c\u76f8\u4e92\u8a3c\u5238").put((Object)"0905", (Object)"\u6771\u4eac\u91d1\u878d\u53d6\u5f15\u6240").put((Object)"0909", (Object)"\u65e5\u672c\u30af\u30ea\u30a2\u6a5f\u69cb").put((Object)"0910", (Object)"\u307b\u3075\u308a\u30af\u30ea\u30a2").put((Object)"0964", (Object)"\u3057\u3093\u304d\u3093\u8a3c\u5238").put((Object)"0966", (Object)"\uff28\uff33\uff22\uff23\u8a3c\u5238").put((Object)"0968", (Object)"\u30bb\u30f3\u30c8\u6771\u77ed\u8a3c\u5238").put((Object)"0971", (Object)"\uff35\uff22\uff33\u8a3c\u5238").put((Object)"0972", (Object)"\u30e1\u30ea\u30eb\u65e5\u672c\u8a3c\u5238").build();
    private static final Map<String, String> minorBanksJapanese = ImmutableMap.builder().put((Object)"1000", (Object)"\u4fe1\u91d1\u4e2d\u592e\u91d1\u5eab").put((Object)"1001", (Object)"\u5317\u6d77\u9053\u4fe1\u91d1").put((Object)"1003", (Object)"\u5ba4\u862d\u4fe1\u91d1").put((Object)"1004", (Object)"\u7a7a\u77e5\u4fe1\u91d1").put((Object)"1006", (Object)"\u82eb\u5c0f\u7267\u4fe1\u91d1").put((Object)"1008", (Object)"\u5317\u9580\u4fe1\u91d1").put((Object)"1009", (Object)"\u4f0a\u9054\u4fe1\u91d1").put((Object)"1010", (Object)"\u5317\u7a7a\u77e5\u4fe1\u91d1").put((Object)"1011", (Object)"\u65e5\u9ad8\u4fe1\u91d1").put((Object)"1013", (Object)"\u6e21\u5cf6\u4fe1\u91d1").put((Object)"1014", (Object)"\u9053\u5357\u3046\u307f\u8857\u4fe1\u91d1").put((Object)"1020", (Object)"\u65ed\u5ddd\u4fe1\u91d1").put((Object)"1021", (Object)"\u7a1a\u5185\u4fe1\u91d1").put((Object)"1022", (Object)"\u7559\u840c\u4fe1\u91d1").put((Object)"1024", (Object)"\u5317\u661f\u4fe1\u91d1").put((Object)"1026", (Object)"\u5e2f\u5e83\u4fe1\u91d1").put((Object)"1027", (Object)"\u91e7\u8def\u4fe1\u91d1").put((Object)"1028", (Object)"\u5927\u5730\u307f\u3089\u3044\u4fe1\u91d1").put((Object)"1030", (Object)"\u5317\u898b\u4fe1\u91d1").put((Object)"1031", (Object)"\u7db2\u8d70\u4fe1\u91d1").put((Object)"1033", (Object)"\u9060\u8efd\u4fe1\u91d1").put((Object)"1104", (Object)"\u6771\u5965\u4fe1\u91d1").put((Object)"1105", (Object)"\u9752\u3044\u68ee\u4fe1\u91d1").put((Object)"1120", (Object)"\u79cb\u7530\u4fe1\u91d1").put((Object)"1123", (Object)"\u7fbd\u5f8c\u4fe1\u91d1").put((Object)"1140", (Object)"\u5c71\u5f62\u4fe1\u91d1").put((Object)"1141", (Object)"\u7c73\u6ca2\u4fe1\u91d1").put((Object)"1142", (Object)"\u9db4\u5ca1\u4fe1\u91d1").put((Object)"1143", (Object)"\u65b0\u5e84\u4fe1\u91d1").put((Object)"1150", (Object)"\u76db\u5ca1\u4fe1\u91d1").put((Object)"1152", (Object)"\u5bae\u53e4\u4fe1\u91d1").put((Object)"1153", (Object)"\u4e00\u95a2\u4fe1\u91d1").put((Object)"1154", (Object)"\u5317\u4e0a\u4fe1\u91d1").put((Object)"1155", (Object)"\u82b1\u5dfb\u4fe1\u91d1").put((Object)"1156", (Object)"\u6c34\u6ca2\u4fe1\u91d1").put((Object)"1170", (Object)"\u675c\u306e\u90fd\u4fe1\u91d1").put((Object)"1171", (Object)"\u5bae\u57ce\u7b2c\u4e00\u4fe1\u91d1").put((Object)"1172", (Object)"\u77f3\u5dfb\u4fe1\u91d1").put((Object)"1174", (Object)"\u4ed9\u5357\u4fe1\u91d1").put((Object)"1181", (Object)"\u4f1a\u6d25\u4fe1\u91d1").put((Object)"1182", (Object)"\u90e1\u5c71\u4fe1\u91d1").put((Object)"1184", (Object)"\u767d\u6cb3\u4fe1\u91d1").put((Object)"1185", (Object)"\u9808\u8cc0\u5ddd\u4fe1\u91d1").put((Object)"1186", (Object)"\u3072\u307e\u308f\u308a\u4fe1\u91d1").put((Object)"1188", (Object)"\u3042\u3076\u304f\u307e\u4fe1\u91d1").put((Object)"1189", (Object)"\u4e8c\u672c\u677e\u4fe1\u91d1").put((Object)"1190", (Object)"\u798f\u5cf6\u4fe1\u91d1").put((Object)"1203", (Object)"\u9ad8\u5d0e\u4fe1\u91d1").put((Object)"1204", (Object)"\u6850\u751f\u4fe1\u91d1").put((Object)"1206", (Object)"\u30a2\u30a4\u30aa\u30fc\u4fe1\u91d1").put((Object)"1208", (Object)"\u5229\u6839\u90e1\u4fe1\u91d1").put((Object)"1209", (Object)"\u9928\u6797\u4fe1\u91d1").put((Object)"1210", (Object)"\u5317\u7fa4\u99ac\u4fe1\u91d1").put((Object)"1211", (Object)"\u3057\u306e\u306e\u3081\u4fe1\u91d1").put((Object)"1221", (Object)"\u8db3\u5229\u5c0f\u5c71\u4fe1\u91d1").put((Object)"1222", (Object)"\u6803\u6728\u4fe1\u91d1").put((Object)"1223", (Object)"\u9e7f\u6cbc\u76f8\u4e92\u4fe1\u91d1").put((Object)"1224", (Object)"\u4f50\u91ce\u4fe1\u91d1").put((Object)"1225", (Object)"\u5927\u7530\u539f\u4fe1\u91d1").put((Object)"1227", (Object)"\u70cf\u5c71\u4fe1\u91d1").put((Object)"1240", (Object)"\u6c34\u6238\u4fe1\u91d1").put((Object)"1242", (Object)"\u7d50\u57ce\u4fe1\u91d1").put((Object)"1250", (Object)"\u57fc\u7389\u770c\u4fe1\u91d1").put((Object)"1251", (Object)"\u5ddd\u53e3\u4fe1\u91d1").put((Object)"1252", (Object)"\u9752\u6728\u4fe1\u91d1").put((Object)"1253", (Object)"\u98ef\u80fd\u4fe1\u91d1").put((Object)"1260", (Object)"\u5343\u8449\u4fe1\u91d1").put((Object)"1261", (Object)"\u929a\u5b50\u4fe1\u91d1").put((Object)"1262", (Object)"\u6771\u4eac\u30d9\u30a4\u4fe1\u91d1").put((Object)"1264", (Object)"\u9928\u5c71\u4fe1\u91d1").put((Object)"1267", (Object)"\u4f50\u539f\u4fe1\u91d1").put((Object)"1280", (Object)"\u6a2a\u6d5c\u4fe1\u91d1").put((Object)"1281", (Object)"\u304b\u306a\u304c\u308f\u4fe1\u91d1").put((Object)"1282", (Object)"\u6e58\u5357\u4fe1\u91d1").put((Object)"1283", (Object)"\u5ddd\u5d0e\u4fe1\u91d1").put((Object)"1286", (Object)"\u5e73\u585a\u4fe1\u91d1").put((Object)"1288", (Object)"\u3055\u304c\u307f\u4fe1\u91d1").put((Object)"1289", (Object)"\u4e2d\u6804\u4fe1\u91d1").put((Object)"1290", (Object)"\u4e2d\u5357\u4fe1\u91d1").put((Object)"1303", (Object)"\u671d\u65e5\u4fe1\u91d1").put((Object)"1305", (Object)"\u8208\u7523\u4fe1\u91d1").put((Object)"1310", (Object)"\u3055\u308f\u3084\u304b\u4fe1\u91d1").put((Object)"1311", (Object)"\u6771\u4eac\u30b7\u30c6\u30a4\u4fe1\u91d1").put((Object)"1319", (Object)"\u829d\u4fe1\u91d1").put((Object)"1320", (Object)"\u6771\u4eac\u6771\u4fe1\u91d1").put((Object)"1321", (Object)"\u6771\u6804\u4fe1\u91d1").put((Object)"1323", (Object)"\u4e80\u6709\u4fe1\u91d1").put((Object)"1326", (Object)"\u5c0f\u677e\u5ddd\u4fe1\u91d1").put((Object)"1327", (Object)"\u8db3\u7acb\u6210\u548c\u4fe1\u91d1").put((Object)"1333", (Object)"\u6771\u4eac\u4e09\u5354\u4fe1\u91d1").put((Object)"1336", (Object)"\u897f\u4eac\u4fe1\u91d1").put((Object)"1341", (Object)"\u897f\u6b66\u4fe1\u91d1").put((Object)"1344", (Object)"\u57ce\u5357\u4fe1\u91d1").put((Object)"1345", (Object)"\u6771\u4eac\uff09\u662d\u548c\u4fe1\u91d1").put((Object)"1346", (Object)"\u76ee\u9ed2\u4fe1\u91d1").put((Object)"1348", (Object)"\u4e16\u7530\u8c37\u4fe1\u91d1").put((Object)"1349", (Object)"\u6771\u4eac\u4fe1\u91d1").put((Object)"1351", (Object)"\u57ce\u5317\u4fe1\u91d1").put((Object)"1352", (Object)"\u6edd\u91ce\u5ddd\u4fe1\u91d1").put((Object)"1356", (Object)"\u5de3\u9d28\u4fe1\u91d1").put((Object)"1358", (Object)"\u9752\u6885\u4fe1\u91d1").put((Object)"1360", (Object)"\u591a\u6469\u4fe1\u91d1").put((Object)"1370", (Object)"\u65b0\u6f5f\u4fe1\u91d1").put((Object)"1371", (Object)"\u9577\u5ca1\u4fe1\u91d1").put((Object)"1373", (Object)"\u4e09\u6761\u4fe1\u91d1").put((Object)"1374", (Object)"\u65b0\u767a\u7530\u4fe1\u91d1").put((Object)"1375", (Object)"\u67cf\u5d0e\u4fe1\u91d1").put((Object)"1376", (Object)"\u4e0a\u8d8a\u4fe1\u91d1").put((Object)"1377", (Object)"\u65b0\u4e95\u4fe1\u91d1").put((Object)"1379", (Object)"\u6751\u4e0a\u4fe1\u91d1").put((Object)"1380", (Object)"\u52a0\u8302\u4fe1\u91d1").put((Object)"1385", (Object)"\u7532\u5e9c\u4fe1\u91d1").put((Object)"1386", (Object)"\u5c71\u68a8\u4fe1\u91d1").put((Object)"1390", (Object)"\u9577\u91ce\u4fe1\u91d1").put((Object)"1391", (Object)"\u677e\u672c\u4fe1\u91d1").put((Object)"1392", (Object)"\u4e0a\u7530\u4fe1\u91d1").put((Object)"1393", (Object)"\u8acf\u8a2a\u4fe1\u91d1").put((Object)"1394", (Object)"\u98ef\u7530\u4fe1\u91d1").put((Object)"1396", (Object)"\u30a2\u30eb\u30d7\u30b9\u4fe1\u91d1").put((Object)"1401", (Object)"\u5bcc\u5c71\u4fe1\u91d1").put((Object)"1402", (Object)"\u9ad8\u5ca1\u4fe1\u91d1").put((Object)"1405", (Object)"\u306b\u3044\u304b\u308f\u4fe1\u91d1").put((Object)"1406", (Object)"\u6c37\u898b\u4f0f\u6728\u4fe1\u91d1").put((Object)"1412", (Object)"\u783a\u6ce2\u4fe1\u91d1").put((Object)"1413", (Object)"\u77f3\u52d5\u4fe1\u91d1").put((Object)"1440", (Object)"\u91d1\u6ca2\u4fe1\u91d1").put((Object)"1442", (Object)"\u306e\u3068\u5171\u6804\u4fe1\u91d1").put((Object)"1444", (Object)"\u5317\u9678\u4fe1\u91d1").put((Object)"1445", (Object)"\u9db4\u6765\u4fe1\u91d1").put((Object)"1448", (Object)"\u8208\u80fd\u4fe1\u91d1").put((Object)"1470", (Object)"\u798f\u4e95\u4fe1\u91d1").put((Object)"1471", (Object)"\u6566\u8cc0\u4fe1\u91d1").put((Object)"1473", (Object)"\u5c0f\u6d5c\u4fe1\u91d1").put((Object)"1475", (Object)"\u8d8a\u524d\u4fe1\u91d1").put((Object)"1501", (Object)"\u3057\u305a\u713c\u6d25\u4fe1\u91d1").put((Object)"1502", (Object)"\u9759\u6e05\u4fe1\u91d1").put((Object)"1503", (Object)"\u6d5c\u677e\u78d0\u7530\u4fe1\u91d1").put((Object)"1505", (Object)"\u6cbc\u6d25\u4fe1\u91d1").put((Object)"1506", (Object)"\u4e09\u5cf6\u4fe1\u91d1").put((Object)"1507", (Object)"\u5bcc\u58eb\u5bae\u4fe1\u91d1").put((Object)"1513", (Object)"\u5cf6\u7530\u639b\u5ddd\u4fe1\u91d1").put((Object)"1515", (Object)"\u9759\u5ca1\uff09\u5bcc\u58eb\u4fe1\u91d1").put((Object)"1517", (Object)"\u9060\u5dde\u4fe1\u91d1").put((Object)"1530", (Object)"\u5c90\u961c\u4fe1\u91d1").put((Object)"1531", (Object)"\u5927\u57a3\u897f\u6fc3\u4fe1\u91d1").put((Object)"1532", (Object)"\u9ad8\u5c71\u4fe1\u91d1").put((Object)"1533", (Object)"\u6771\u6fc3\u4fe1\u91d1").put((Object)"1534", (Object)"\u95a2\u4fe1\u91d1").put((Object)"1538", (Object)"\u516b\u5e61\u4fe1\u91d1").put((Object)"1550", (Object)"\u611b\u77e5\u4fe1\u91d1").put((Object)"1551", (Object)"\u8c4a\u6a4b\u4fe1\u91d1").put((Object)"1552", (Object)"\u5ca1\u5d0e\u4fe1\u91d1").put((Object)"1553", (Object)"\u3044\u3061\u3044\u4fe1\u91d1").put((Object)"1554", (Object)"\u702c\u6238\u4fe1\u91d1").put((Object)"1555", (Object)"\u534a\u7530\u4fe1\u91d1").put((Object)"1556", (Object)"\u77e5\u591a\u4fe1\u91d1").put((Object)"1557", (Object)"\u8c4a\u5ddd\u4fe1\u91d1").put((Object)"1559", (Object)"\u8c4a\u7530\u4fe1\u91d1").put((Object)"1560", (Object)"\u78a7\u6d77\u4fe1\u91d1").put((Object)"1561", (Object)"\u897f\u5c3e\u4fe1\u91d1").put((Object)"1562", (Object)"\u84b2\u90e1\u4fe1\u91d1").put((Object)"1563", (Object)"\u5c3e\u897f\u4fe1\u91d1").put((Object)"1565", (Object)"\u4e2d\u65e5\u4fe1\u91d1").put((Object)"1566", (Object)"\u6771\u6625\u4fe1\u91d1").put((Object)"1580", (Object)"\u6d25\u4fe1\u91d1").put((Object)"1581", (Object)"\u5317\u4f0a\u52e2\u4e0a\u91ce\u4fe1\u91d1").put((Object)"1583", (Object)"\u6851\u540d\u4e09\u91cd\u4fe1\u91d1").put((Object)"1585", (Object)"\u7d00\u5317\u4fe1\u91d1").put((Object)"1602", (Object)"\u6ecb\u8cc0\u4e2d\u592e\u4fe1\u91d1").put((Object)"1603", (Object)"\u9577\u6d5c\u4fe1\u91d1").put((Object)"1604", (Object)"\u6e56\u6771\u4fe1\u91d1").put((Object)"1610", (Object)"\u4eac\u90fd\u4fe1\u91d1").put((Object)"1611", (Object)"\u4eac\u90fd\u4e2d\u592e\u4fe1\u91d1").put((Object)"1620", (Object)"\u4eac\u90fd\u5317\u90fd\u4fe1\u91d1").put((Object)"1630", (Object)"\u5927\u962a\u4fe1\u91d1").put((Object)"1633", (Object)"\u5927\u962a\u539a\u751f\u4fe1\u91d1").put((Object)"1635", (Object)"\u5927\u962a\u30b7\u30c6\u30a4\u4fe1\u91d1").put((Object)"1636", (Object)"\u5927\u962a\u5546\u5de5\u4fe1\u91d1").put((Object)"1643", (Object)"\u6c38\u548c\u4fe1\u91d1").put((Object)"1645", (Object)"\u5317\u304a\u304a\u3055\u304b\u4fe1\u91d1").put((Object)"1656", (Object)"\u679a\u65b9\u4fe1\u91d1").put((Object)"1666", (Object)"\u5948\u826f\u4fe1\u91d1").put((Object)"1667", (Object)"\u5927\u548c\u4fe1\u91d1").put((Object)"1668", (Object)"\u5948\u826f\u4e2d\u592e\u4fe1\u91d1").put((Object)"1671", (Object)"\u65b0\u5bae\u4fe1\u91d1").put((Object)"1674", (Object)"\u304d\u306e\u304f\u306b\u4fe1\u91d1").put((Object)"1680", (Object)"\u795e\u6238\u4fe1\u91d1").put((Object)"1685", (Object)"\u59eb\u8def\u4fe1\u91d1").put((Object)"1686", (Object)"\u64ad\u5dde\u4fe1\u91d1").put((Object)"1687", (Object)"\u5175\u5eab\u4fe1\u91d1").put((Object)"1688", (Object)"\u5c3c\u5d0e\u4fe1\u91d1").put((Object)"1689", (Object)"\u65e5\u65b0\u4fe1\u91d1").put((Object)"1691", (Object)"\u6de1\u8def\u4fe1\u91d1").put((Object)"1692", (Object)"\u4f46\u99ac\u4fe1\u91d1").put((Object)"1694", (Object)"\u897f\u5175\u5eab\u4fe1\u91d1").put((Object)"1695", (Object)"\u4e2d\u5175\u5eab\u4fe1\u91d1").put((Object)"1696", (Object)"\u4f46\u967d\u4fe1\u91d1").put((Object)"1701", (Object)"\u9ce5\u53d6\u4fe1\u91d1").put((Object)"1702", (Object)"\u7c73\u5b50\u4fe1\u91d1").put((Object)"1703", (Object)"\u5009\u5409\u4fe1\u91d1").put((Object)"1710", (Object)"\u3057\u307e\u306d\u4fe1\u91d1").put((Object)"1711", (Object)"\u65e5\u672c\u6d77\u4fe1\u91d1").put((Object)"1712", (Object)"\u5cf6\u6839\u4e2d\u592e\u4fe1\u91d1").put((Object)"1732", (Object)"\u304a\u304b\u3084\u307e\u4fe1\u91d1").put((Object)"1734", (Object)"\u6c34\u5cf6\u4fe1\u91d1").put((Object)"1735", (Object)"\u6d25\u5c71\u4fe1\u91d1").put((Object)"1738", (Object)"\u7389\u5cf6\u4fe1\u91d1").put((Object)"1740", (Object)"\u5099\u5317\u4fe1\u91d1").put((Object)"1741", (Object)"\u5409\u5099\u4fe1\u91d1").put((Object)"1742", (Object)"\u65e5\u751f\u4fe1\u91d1").put((Object)"1743", (Object)"\u5099\u524d\u4fe1\u91d1").put((Object)"1750", (Object)"\u5e83\u5cf6\u4fe1\u91d1").put((Object)"1752", (Object)"\u5449\u4fe1\u91d1").put((Object)"1756", (Object)"\u3057\u307e\u306a\u307f\u4fe1\u91d1").put((Object)"1758", (Object)"\u5e83\u5cf6\u307f\u3069\u308a\u4fe1\u91d1").put((Object)"1780", (Object)"\u8429\u5c71\u53e3\u4fe1\u91d1").put((Object)"1781", (Object)"\u897f\u4e2d\u56fd\u4fe1\u91d1").put((Object)"1789", (Object)"\u6771\u5c71\u53e3\u4fe1\u91d1").put((Object)"1801", (Object)"\u5fb3\u5cf6\u4fe1\u91d1").put((Object)"1803", (Object)"\u963f\u5357\u4fe1\u91d1").put((Object)"1830", (Object)"\u9ad8\u677e\u4fe1\u91d1").put((Object)"1833", (Object)"\u89b3\u97f3\u5bfa\u4fe1\u91d1").put((Object)"1860", (Object)"\u611b\u5a9b\u4fe1\u91d1").put((Object)"1862", (Object)"\u5b87\u548c\u5cf6\u4fe1\u91d1").put((Object)"1864", (Object)"\u6771\u4e88\u4fe1\u91d1").put((Object)"1866", (Object)"\u5ddd\u4e4b\u6c5f\u4fe1\u91d1").put((Object)"1880", (Object)"\u5e61\u591a\u4fe1\u91d1").put((Object)"1881", (Object)"\u9ad8\u77e5\u4fe1\u91d1").put((Object)"1901", (Object)"\u798f\u5ca1\u4fe1\u91d1").put((Object)"1903", (Object)"\u798f\u5ca1\u3072\u3073\u304d\u4fe1\u91d1").put((Object)"1908", (Object)"\u5927\u725f\u7530\u67f3\u5ddd\u4fe1\u91d1").put((Object)"1909", (Object)"\u7b51\u5f8c\u4fe1\u91d1").put((Object)"1910", (Object)"\u98ef\u585a\u4fe1\u91d1").put((Object)"1917", (Object)"\u5927\u5ddd\u4fe1\u91d1").put((Object)"1920", (Object)"\u9060\u8cc0\u4fe1\u91d1").put((Object)"1930", (Object)"\u5510\u6d25\u4fe1\u91d1").put((Object)"1931", (Object)"\u4f50\u8cc0\u4fe1\u91d1").put((Object)"1933", (Object)"\u4e5d\u5dde\u3072\u305c\u3093\u4fe1\u91d1").put((Object)"1942", (Object)"\u305f\u3061\u3070\u306a\u4fe1\u91d1").put((Object)"1951", (Object)"\u718a\u672c\u4fe1\u91d1").put((Object)"1952", (Object)"\u718a\u672c\u7b2c\u4e00\u4fe1\u91d1").put((Object)"1954", (Object)"\u718a\u672c\u4e2d\u592e\u4fe1\u91d1").put((Object)"1960", (Object)"\u5927\u5206\u4fe1\u91d1").put((Object)"1962", (Object)"\u5927\u5206\u307f\u3089\u3044\u4fe1\u91d1").put((Object)"1980", (Object)"\u5bae\u5d0e\u90fd\u57ce\u4fe1\u91d1").put((Object)"1985", (Object)"\u9ad8\u934b\u4fe1\u91d1").put((Object)"1990", (Object)"\u9e7f\u5150\u5cf6\u4fe1\u91d1").put((Object)"1991", (Object)"\u9e7f\u5150\u5cf6\u76f8\u4e92\u4fe1\u91d1").put((Object)"1993", (Object)"\u5944\u7f8e\u5927\u5cf6\u4fe1\u91d1").put((Object)"1996", (Object)"\u30b3\u30b6\u4fe1\u91d1").put((Object)"2004", (Object)"\u5546\u5de5\u7d44\u5408\u4e2d\u592e\u91d1\u5eab").put((Object)"2010", (Object)"\u5168\u56fd\u4fe1\u7528\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"2213", (Object)"\u6574\u7406\u56de\u53ce\u6a5f\u69cb").put((Object)"2950", (Object)"\u52b4\u50cd\u91d1\u5eab\u9023\u5408\u4f1a").put((Object)"3000", (Object)"\u8fb2\u6797\u4e2d\u592e\u91d1\u5eab").put((Object)"3001", (Object)"\u5317\u6d77\u9053\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3003", (Object)"\u5ca9\u624b\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3008", (Object)"\u8328\u57ce\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3011", (Object)"\u57fc\u7389\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3013", (Object)"\u6771\u4eac\u90fd\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3014", (Object)"\u795e\u5948\u5ddd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3015", (Object)"\u5c71\u68a8\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3016", (Object)"\u9577\u91ce\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3017", (Object)"\u65b0\u6f5f\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3019", (Object)"\u77f3\u5ddd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3020", (Object)"\u5c90\u961c\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3021", (Object)"\u9759\u5ca1\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3022", (Object)"\u611b\u77e5\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3023", (Object)"\u4e09\u91cd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3024", (Object)"\u798f\u4e95\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3025", (Object)"\u6ecb\u8cc0\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3026", (Object)"\u4eac\u90fd\u5e9c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3027", (Object)"\u5927\u962a\u5e9c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3028", (Object)"\u5175\u5eab\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3030", (Object)"\u548c\u6b4c\u5c71\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3031", (Object)"\u9ce5\u53d6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3034", (Object)"\u5e83\u5cf6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3035", (Object)"\u5c71\u53e3\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3036", (Object)"\u5fb3\u5cf6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3037", (Object)"\u9999\u5ddd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3038", (Object)"\u611b\u5a9b\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3039", (Object)"\u9ad8\u77e5\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3040", (Object)"\u798f\u5ca1\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3041", (Object)"\u4f50\u8cc0\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3044", (Object)"\u5927\u5206\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3045", (Object)"\u5bae\u5d0e\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"3046", (Object)"\u9e7f\u5150\u5cf6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9450", (Object)"\u5317\u6d77\u9053\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9451", (Object)"\u9752\u68ee\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9452", (Object)"\u5ca9\u624b\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9453", (Object)"\u5bae\u57ce\u770c\u6f01\u696d\u5354\u540c\u7d44\u5408").put((Object)"9456", (Object)"\u798f\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9457", (Object)"\u8328\u57ce\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9461", (Object)"\u5343\u8449\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9462", (Object)"\u6771\u4eac\u90fd\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9466", (Object)"\u65b0\u6f5f\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9467", (Object)"\u5bcc\u5c71\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9468", (Object)"\u77f3\u5ddd\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9470", (Object)"\u9759\u5ca1\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9471", (Object)"\u611b\u77e5\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9472", (Object)"\u4e09\u91cd\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9473", (Object)"\u798f\u4e95\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9475", (Object)"\u4eac\u90fd\u5e9c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9477", (Object)"\u306a\u304e\u3055\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9480", (Object)"\u9ce5\u53d6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9481", (Object)"\uff2a\uff26\u3057\u307e\u306d\u6f01\u696d\u5354\u540c\u7d44\u5408").put((Object)"9483", (Object)"\u5e83\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9484", (Object)"\u5c71\u53e3\u770c\u6f01\u696d\u5354\u540c\u7d44\u5408").put((Object)"9485", (Object)"\u5fb3\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9486", (Object)"\u9999\u5ddd\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9487", (Object)"\u611b\u5a9b\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9488", (Object)"\u9ad8\u77e5\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9489", (Object)"\u798f\u5ca1\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9490", (Object)"\u4f50\u8cc0\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9491", (Object)"\u9577\u5d0e\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9493", (Object)"\u5927\u5206\u770c\u6f01\u696d\u5354\u540c\u7d44\u5408").put((Object)"9494", (Object)"\u5bae\u5d0e\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9495", (Object)"\u9e7f\u5150\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9496", (Object)"\u6c96\u7e04\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put((Object)"9500", (Object)"\u6771\u4eac\u77ed\u8cc7").put((Object)"9501", (Object)"\u30bb\u30f3\u30c8\u30e9\u30eb\u77ed\u8cc7").put((Object)"9507", (Object)"\u4e0a\u7530\u516b\u6728\u77ed\u8cc7").put((Object)"9510", (Object)"\u65e5\u672c\u8a3c\u5238\u91d1\u878d").put((Object)"9520", (Object)"\u91ce\u6751\u8a3c\u5238").put((Object)"9521", (Object)"\u65e5\u8208\u8a3c\u5238").put((Object)"9523", (Object)"\u5927\u548c\u8a3c\u5238").put((Object)"9524", (Object)"\u307f\u305a\u307b\u8a3c\u5238").put((Object)"9528", (Object)"\u5ca1\u4e09\u8a3c\u5238").put((Object)"9530", (Object)"\u5ca9\u4e95\u30b3\u30b9\u30e2\u8a3c\u5238").put((Object)"9532", (Object)"\u4e09\u83f1\uff35\uff26\uff2a\u8a3c\u5238").put((Object)"9534", (Object)"\u4e38\u4e09\u8a3c\u5238").put((Object)"9535", (Object)"\u6771\u6d0b\u8a3c\u5238").put((Object)"9537", (Object)"\u6c34\u6238\u8a3c\u5238").put((Object)"9539", (Object)"\u6771\u6d77\u6771\u4eac\u8a3c\u5238").put((Object)"9542", (Object)"\u3080\u3055\u3057\u8a3c\u5238").put((Object)"9545", (Object)"\u3044\u3061\u3088\u3057\u8a3c\u5238").put((Object)"9573", (Object)"\u6975\u6771\u8a3c\u5238").put((Object)"9574", (Object)"\u7acb\u82b1\u8a3c\u5238").put((Object)"9579", (Object)"\u5149\u4e16\u8a3c\u5238").put((Object)"9584", (Object)"\u3061\u3070\u304e\u3093\u8a3c\u5238").put((Object)"9589", (Object)"\u30b7\u30c6\u30a4\u8a3c\u5238").put((Object)"9594", (Object)"\uff23\uff33\u8a3c\u5238").put((Object)"9595", (Object)"\u30b9\u30bf\u30f3\u30ec\u30fc\u8a3c\u5238").put((Object)"9930", (Object)"\u65e5\u672c\u653f\u7b56\u6295\u8cc7").put((Object)"9932", (Object)"\u653f\u7b56\u91d1\u878d\u516c\u5eab").put((Object)"9933", (Object)"\u56fd\u969b\u5354\u529b").put((Object)"9945", (Object)"\u9810\u91d1\u4fdd\u967a\u6a5f\u69cb").build();
    private static final String ID_OPEN = "";
    private static final String ID_CLOSE = "";
    private static final String JA_OPEN = "";
    private static final String JA_CLOSE = "";
    private static final String EN_OPEN = "";
    private static final String EN_CLOSE = "";
    public static final String SPACE = " ";

    public static List<String> prettyPrintBankList() {
        String bankNameJa;
        String bankId;
        ArrayList<String> prettyList = new ArrayList<String>();
        for (Map.Entry<String, String> bank : megaBanksEnglish.entrySet()) {
            bankId = bank.getKey();
            String bankNameEn = bank.getValue();
            String bankNameJa2 = majorBanksJapanese.get(bankId);
            if (bankNameJa2 == null) {
                bankNameJa2 = minorBanksJapanese.get(bankId);
            }
            prettyList.add(JapanBankData.prettyPrintMajorBank(bankId, bankNameJa2, bankNameEn));
        }
        for (Map.Entry<String, String> bank : majorBanksJapanese.entrySet()) {
            bankId = bank.getKey();
            bankNameJa = bank.getValue();
            if (megaBanksEnglish.get(bankId) != null) continue;
            prettyList.add(JapanBankData.prettyPrintBank(bankId, bankNameJa));
        }
        for (Map.Entry<String, String> bank : minorBanksJapanese.entrySet()) {
            bankId = bank.getKey();
            bankNameJa = bank.getValue();
            prettyList.add(JapanBankData.prettyPrintBank(bankId, bankNameJa));
        }
        return prettyList;
    }

    private static String prettyPrintMajorBank(String bankId, String bankNameJa, String bankNameEn) {
        return bankId + SPACE + bankNameJa + SPACE + bankNameEn;
    }

    private static String prettyPrintBank(String bankId, String bankName) {
        return bankId + SPACE + bankName;
    }

    public static String getString(String id) {
        boolean ja = HavenoUtils.preferences.getUserLanguage().equals("ja");
        switch (id) {
            case "bank": {
                if (ja) {
                    return "\u9280\u884c\u540d \u30fb\u91d1\u878d\u6a5f\u95a2\u540d";
                }
                return "Bank or Financial Institution";
            }
            case "bank.select": {
                if (ja) {
                    return "\u91d1\u878d\u6a5f\u95a2 \u30fb\u9280\u884c\u691c\u7d22 (\u540d\u79f0\u5165\u529b\u691c\u7d22)";
                }
                return "Search for Bank or Financial Institution";
            }
            case "bank.code": {
                if (ja) {
                    return "\u9280\u884c\u30b3\u30fc\u30c9";
                }
                return "Zengin Bank Code";
            }
            case "bank.name": {
                if (ja) {
                    return "\u91d1\u878d\u6a5f\u95a2\u540d \u30fb\u9280\u884c\u540d";
                }
                return "Financial Institution / Bank Name";
            }
            case "branch": {
                if (ja) {
                    return "\u652f\u5e97\u540d";
                }
                return "Bank Branch";
            }
            case "branch.code": {
                if (ja) {
                    return "\u652f\u5e97\u30b3\u30fc\u30c9";
                }
                return "Zengin Branch Code";
            }
            case "branch.code.validation.error": {
                if (ja) {
                    return "\u5165\u529b\u306f3\u6841\u306e\u652f\u5e97\u30b3\u30fc\u30c9\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093";
                }
                return "Input must be a 3 digit branch code";
            }
            case "branch.name": {
                if (ja) {
                    return "\u652f\u5e97\u540d";
                }
                return "Bank Branch Name";
            }
            case "account": {
                if (ja) {
                    return "\u9280\u884c\u53e3\u5ea7";
                }
                return "Bank Account";
            }
            case "account.type": {
                if (ja) {
                    return "\u53e3\u5ea7\u79d1\u76ee";
                }
                return "Bank Account Type";
            }
            case "account.type.select": {
                if (ja) {
                    return "\u53e3\u5ea7\u79d1\u76ee";
                }
                return "Select Account Type";
            }
            case "account.type.futsu": {
                if (ja) {
                    return "\u666e\u901a";
                }
                return "FUTSUU (ordinary) account";
            }
            case "account.type.touza": {
                if (ja) {
                    return "\u5f53\u5ea7";
                }
                return "TOUZA (checking) account";
            }
            case "account.type.chochiku": {
                if (ja) {
                    return "\u8caf\u91d1";
                }
                return "CHOCHIKU (special) account";
            }
            case "account.type.futsu.ja": {
                return "\u666e\u901a";
            }
            case "account.type.touza.ja": {
                return "\u5f53\u5ea7";
            }
            case "account.type.chochiku.ja": {
                return "\u8caf\u91d1";
            }
            case "account.number": {
                if (ja) {
                    return "\u53e3\u5ea7\u756a\u53f7";
                }
                return "Bank Account Number";
            }
            case "account.number.validation.error": {
                if (ja) {
                    return "\u5165\u529b\u306f4\u301c8\u6841\u306e\u53e3\u5ea7\u756a\u53f7\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093";
                }
                return "Input must be 4 ~ 8 digit account number";
            }
            case "account.name": {
                if (ja) {
                    return "\u53e3\u5ea7\u540d\u7fa9";
                }
                return "Bank Account Name";
            }
            case "japanese.validation.error": {
                if (ja) {
                    return "\u5165\u529b\u306f\u6f22\u5b57\u3001\u3072\u3089\u304c\u306a\u3001\u307e\u305f\u306f\u30ab\u30bf\u30ab\u30ca\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093";
                }
                return "Input must be Kanji, Hiragana, or Katakana";
            }
            case "japanese.validation.regex": {
                return "[\u4e00-\u9faf\u3005\u3007\u3041-\u309e\u30a1-\u30fb\uff67-\uff9d\uff9e\uff9f\u30fd\u30fe\u309b\u309c\u30fc\u3000 ]+";
            }
        }
        return "null";
    }
}

