/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.ImpsAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class ImpsAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("INR"));

    public ImpsAccount() {
        super(PaymentMethod.IMPS);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new ImpsAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.imps.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.imps.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.imps.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImpsAccount)) {
            return false;
        }
        ImpsAccount other = (ImpsAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImpsAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

