/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.FasterPaymentsAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class FasterPaymentsAccount
extends PaymentAccount {
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.HOLDER_NAME, PaymentAccountFormField.FieldId.SORT_CODE, PaymentAccountFormField.FieldId.ACCOUNT_NR, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("GBP"));

    public FasterPaymentsAccount() {
        super(PaymentMethod.FASTER_PAYMENTS);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new FasterPaymentsAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setHolderName(String value) {
        ((FasterPaymentsAccountPayload)this.paymentAccountPayload).setHolderName(value);
    }

    public String getHolderName() {
        return ((FasterPaymentsAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setSortCode(String value) {
        ((FasterPaymentsAccountPayload)this.paymentAccountPayload).setSortCode(value);
    }

    public String getSortCode() {
        return ((FasterPaymentsAccountPayload)this.paymentAccountPayload).getSortCode();
    }

    public void setAccountNr(String value) {
        ((FasterPaymentsAccountPayload)this.paymentAccountPayload).setAccountNr(value);
    }

    public String getAccountNr() {
        return ((FasterPaymentsAccountPayload)this.paymentAccountPayload).getAccountNr();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FasterPaymentsAccount)) {
            return false;
        }
        FasterPaymentsAccount other = (FasterPaymentsAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FasterPaymentsAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

