/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.CashAtAtmAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class CashAtAtmAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = CurrencyUtil.getAllFiatCurrencies();
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.EXTRA_INFO, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);

    public CashAtAtmAccount() {
        super(PaymentMethod.CASH_AT_ATM);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new CashAtAtmAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setExtraInfo(String extraInfo) {
        ((CashAtAtmAccountPayload)this.paymentAccountPayload).setExtraInfo(extraInfo);
    }

    public String getExtraInfo() {
        return ((CashAtAtmAccountPayload)this.paymentAccountPayload).getExtraInfo();
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
        }
        if (field.getId() == PaymentAccountFormField.FieldId.EXTRA_INFO) {
            field.setLabel(Res.get("payment.cashAtAtm.extraInfo.prompt"));
        }
        return field;
    }
}

