/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AustraliaPayidAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class AustraliaPayidAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AUD"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.BANK_ACCOUNT_NAME, PaymentAccountFormField.FieldId.PAYID, PaymentAccountFormField.FieldId.EXTRA_INFO, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);

    public AustraliaPayidAccount() {
        super(PaymentMethod.AUSTRALIA_PAYID);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new AustraliaPayidAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public String getPayid() {
        return ((AustraliaPayidAccountPayload)this.paymentAccountPayload).getPayid();
    }

    public void setPayid(String payid) {
        if (payid == null) {
            payid = "";
        }
        ((AustraliaPayidAccountPayload)this.paymentAccountPayload).setPayid(payid);
    }

    public String getBankAccountName() {
        return ((AustraliaPayidAccountPayload)this.paymentAccountPayload).getBankAccountName();
    }

    public void setBankAccountName(String bankAccountName) {
        if (bankAccountName == null) {
            bankAccountName = "";
        }
        ((AustraliaPayidAccountPayload)this.paymentAccountPayload).setBankAccountName(bankAccountName);
    }

    public void setExtraInfo(String extraInfo) {
        ((AustraliaPayidAccountPayload)this.paymentAccountPayload).setExtraInfo(extraInfo);
    }

    public String getExtraInfo() {
        return ((AustraliaPayidAccountPayload)this.paymentAccountPayload).getExtraInfo();
    }
}

