/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AmazonGiftCardAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class AmazonGiftCardAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AUD"), new TraditionalCurrency("CAD"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("INR"), new TraditionalCurrency("JPY"), new TraditionalCurrency("SAR"), new TraditionalCurrency("SEK"), new TraditionalCurrency("SGD"), new TraditionalCurrency("TRY"), new TraditionalCurrency("USD"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.EMAIL_OR_MOBILE_NR, PaymentAccountFormField.FieldId.COUNTRY, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);
    @Nullable
    private Country country;

    public AmazonGiftCardAccount() {
        super(PaymentMethod.AMAZON_GIFT_CARD);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new AmazonGiftCardAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public String getEmailOrMobileNr() {
        return this.getAmazonGiftCardAccountPayload().getEmailOrMobileNr();
    }

    public void setEmailOrMobileNr(String emailOrMobileNr) {
        this.getAmazonGiftCardAccountPayload().setEmailOrMobileNr(emailOrMobileNr);
    }

    public boolean countryNotSet() {
        return this.getAmazonGiftCardAccountPayload().countryNotSet();
    }

    @Nullable
    public Country getCountry() {
        if (this.country == null) {
            String countryCode = this.getAmazonGiftCardAccountPayload().getCountryCode();
            CountryUtil.findCountryByCode(countryCode).ifPresent(c -> {
                this.country = c;
            });
        }
        return this.country;
    }

    public void setCountry(@NotNull Country country) {
        this.country = country;
        this.getAmazonGiftCardAccountPayload().setCountryCode(country.code);
    }

    private AmazonGiftCardAccountPayload getAmazonGiftCardAccountPayload() {
        return (AmazonGiftCardAccountPayload)this.paymentAccountPayload;
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
        }
        return field;
    }
}

