/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.AdvancedCashAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class AdvancedCashAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("BRL"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("KZT"), new TraditionalCurrency("RUB"), new TraditionalCurrency("UAH"), new TraditionalCurrency("USD"));

    public AdvancedCashAccount() {
        super(PaymentMethod.ADVANCED_CASH);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new AdvancedCashAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    public void setAccountNr(String accountNr) {
        ((AdvancedCashAccountPayload)this.paymentAccountPayload).setAccountNr(accountNr);
    }

    public String getAccountNr() {
        return ((AdvancedCashAccountPayload)this.paymentAccountPayload).getAccountNr();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancedCashAccount)) {
            return false;
        }
        AdvancedCashAccount other = (AdvancedCashAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AdvancedCashAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

