/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.BankUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.SameCountryRestrictedBankAccount;
import haveno.core.payment.payload.AchTransferAccountPayload;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class AchTransferAccount
extends CountryBasedPaymentAccount
implements SameCountryRestrictedBankAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("USD"));
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.HOLDER_NAME, PaymentAccountFormField.FieldId.HOLDER_ADDRESS, PaymentAccountFormField.FieldId.BANK_NAME, PaymentAccountFormField.FieldId.BRANCH_ID, PaymentAccountFormField.FieldId.ACCOUNT_NR, PaymentAccountFormField.FieldId.ACCOUNT_TYPE, PaymentAccountFormField.FieldId.COUNTRY, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);

    public AchTransferAccount() {
        super(PaymentMethod.ACH_TRANSFER);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new AchTransferAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    public String getBankId() {
        return ((BankAccountPayload)this.paymentAccountPayload).getBankId();
    }

    @Override
    public String getCountryCode() {
        return this.getCountry() != null ? this.getCountry().code : "";
    }

    public AchTransferAccountPayload getPayload() {
        return (AchTransferAccountPayload)this.paymentAccountPayload;
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.achTransfer.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.achTransfer.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.achTransfer.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
        }
        if (field.getId() == PaymentAccountFormField.FieldId.BRANCH_ID) {
            field.setLabel(BankUtil.getBranchIdLabel("US"));
        }
        if (field.getId() == PaymentAccountFormField.FieldId.ACCOUNT_TYPE) {
            field.setLabel(BankUtil.getAccountTypeLabel("US"));
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AchTransferAccount)) {
            return false;
        }
        AchTransferAccount other = (AchTransferAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AchTransferAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

