/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.takeoffer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import haveno.common.taskrunner.Model;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.payment.PaymentAccount;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import java.math.BigInteger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeOfferModel
implements Model {
    private static final Logger log = LoggerFactory.getLogger(TakeOfferModel.class);
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final XmrWalletService xmrWalletService;
    private final OfferUtil offerUtil;
    private final PriceFeedService priceFeedService;
    private XmrAddressEntry addressEntry;
    private BigInteger amount;
    private Offer offer;
    private PaymentAccount paymentAccount;
    private BigInteger securityDeposit;
    private boolean useSavingsWallet;
    private BigInteger takerFee;
    private BigInteger totalToPay;
    private BigInteger missingCoin = BigInteger.ZERO;
    private BigInteger totalAvailableBalance;
    private BigInteger availableBalance;
    private boolean isXmrWalletFunded;
    private Volume volume;

    @Inject
    public TakeOfferModel(AccountAgeWitnessService accountAgeWitnessService, XmrWalletService xmrWalletService, OfferUtil offerUtil, PriceFeedService priceFeedService) {
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.xmrWalletService = xmrWalletService;
        this.offerUtil = offerUtil;
        this.priceFeedService = priceFeedService;
    }

    public void initModel(Offer offer, PaymentAccount paymentAccount, BigInteger tradeAmount, boolean useSavingsWallet) {
        this.clearModel();
        this.offer = offer;
        this.paymentAccount = paymentAccount;
        this.addressEntry = this.xmrWalletService.getOrCreateAddressEntry(offer.getId(), XmrAddressEntry.Context.OFFER_FUNDING);
        this.validateModelInputs();
        this.useSavingsWallet = useSavingsWallet;
        this.amount = tradeAmount.min(BigInteger.valueOf(this.getMaxTradeLimit()));
        this.securityDeposit = offer.getDirection() == OfferDirection.SELL ? offer.getOfferPayload().getBuyerSecurityDepositForTradeAmount(this.amount) : offer.getOfferPayload().getSellerSecurityDepositForTradeAmount(this.amount);
        this.takerFee = HavenoUtils.multiply(this.amount, offer.getTakerFeePct());
        this.calculateVolume();
        this.calculateTotalToPay();
        offer.resetState();
        this.priceFeedService.setCurrencyCode(offer.getCounterCurrencyCode());
    }

    public void onComplete() {
    }

    private void calculateTotalToPay() {
        BigInteger feeAndSecDeposit = this.securityDeposit.add(this.takerFee);
        this.totalToPay = this.offer.isBuyOffer() ? feeAndSecDeposit.add(this.amount) : feeAndSecDeposit;
        this.updateBalance();
    }

    private void calculateVolume() {
        Price tradePrice = this.offer.getPrice();
        Volume volumeByAmount = Objects.requireNonNull(tradePrice).getVolumeByAmount(this.amount);
        this.volume = volumeByAmount = VolumeUtil.getAdjustedVolume(volumeByAmount, this.offer.getPaymentMethod().getId());
        this.updateBalance();
    }

    private void updateBalance() {
        this.totalAvailableBalance = this.xmrWalletService.getAvailableBalance();
        if (this.totalToPay != null) {
            this.availableBalance = this.totalToPay.min(this.totalAvailableBalance);
        }
        this.missingCoin = this.offerUtil.getBalanceShortage(this.totalToPay, this.availableBalance);
        this.isXmrWalletFunded = this.offerUtil.isBalanceSufficient(this.totalToPay, this.availableBalance);
    }

    private long getMaxTradeLimit() {
        return this.accountAgeWitnessService.getMyTradeLimit(this.paymentAccount, this.offer.getCounterCurrencyCode(), this.offer.getMirroredDirection(), this.offer.hasBuyerAsTakerWithoutDeposit());
    }

    @NotNull
    public BigInteger getFundsNeededForTrade() {
        return this.securityDeposit.add(this.offer.isBuyOffer() ? this.amount : BigInteger.ZERO);
    }

    private void validateModelInputs() {
        Preconditions.checkNotNull((Object)this.offer, (Object)"offer must not be null");
        Preconditions.checkNotNull((Object)this.offer.getAmount(), (Object)"offer amount must not be null");
        Preconditions.checkArgument((this.offer.getAmount().longValueExact() > 0L ? 1 : 0) != 0, (Object)"offer amount must not be zero");
        Preconditions.checkNotNull((Object)this.offer.getPrice(), (Object)"offer price must not be null");
        Preconditions.checkNotNull((Object)this.paymentAccount, (Object)"payment account must not be null");
        Preconditions.checkNotNull((Object)this.addressEntry, (Object)"address entry must not be null");
    }

    private void clearModel() {
        this.addressEntry = null;
        this.amount = null;
        this.availableBalance = null;
        this.isXmrWalletFunded = false;
        this.missingCoin = BigInteger.ZERO;
        this.offer = null;
        this.paymentAccount = null;
        this.securityDeposit = null;
        this.takerFee = null;
        this.totalAvailableBalance = null;
        this.totalToPay = null;
        this.useSavingsWallet = true;
        this.volume = null;
    }

    public String toString() {
        return "TakeOfferModel{  offer.id=" + this.offer.getId() + "\n  offer.state=" + String.valueOf((Object)this.offer.getState()) + "\n, paymentAccount.id=" + this.paymentAccount.getId() + "\n, paymentAccount.method.id=" + this.paymentAccount.getPaymentMethod().getId() + "\n, useSavingsWallet=" + this.useSavingsWallet + "\n, addressEntry=" + String.valueOf(this.addressEntry) + "\n, amount=" + String.valueOf(this.amount) + "\n, securityDeposit=" + String.valueOf(this.securityDeposit) + "\n, takerFee=" + String.valueOf(this.takerFee) + "\n, totalToPay=" + String.valueOf(this.totalToPay) + "\n, missingCoin=" + String.valueOf(this.missingCoin) + "\n, totalAvailableBalance=" + String.valueOf(this.totalAvailableBalance) + "\n, availableBalance=" + String.valueOf(this.availableBalance) + "\n, volume=" + String.valueOf(this.volume) + "\n, fundsNeededForTrade=" + String.valueOf(this.getFundsNeededForTrade()) + "\n, isXmrWalletFunded=" + this.isXmrWalletFunded + "\n}";
    }

    public XmrAddressEntry getAddressEntry() {
        return this.addressEntry;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public BigInteger getSecurityDeposit() {
        return this.securityDeposit;
    }

    public BigInteger getTakerFee() {
        return this.takerFee;
    }

    public BigInteger getTotalToPay() {
        return this.totalToPay;
    }

    public BigInteger getMissingCoin() {
        return this.missingCoin;
    }

    public BigInteger getTotalAvailableBalance() {
        return this.totalAvailableBalance;
    }

    public BigInteger getAvailableBalance() {
        return this.availableBalance;
    }

    public boolean isXmrWalletFunded() {
        return this.isXmrWalletFunded;
    }

    public Volume getVolume() {
        return this.volume;
    }
}

