/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.placeoffer.tasks;

import haveno.common.app.Version;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.Model;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.availability.DisputeAgentSelection;
import haveno.core.offer.messages.SignOfferRequest;
import haveno.core.offer.placeoffer.PlaceOfferModel;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakerSendSignOfferRequest
extends Task<PlaceOfferModel> {
    private static final Logger log = LoggerFactory.getLogger(MakerSendSignOfferRequest.class);

    public MakerSendSignOfferRequest(TaskRunner taskHandler, PlaceOfferModel model) {
        super(taskHandler, (Model)model);
    }

    protected void run() {
        OpenOffer openOffer = ((PlaceOfferModel)this.model).getOpenOffer();
        Offer offer = openOffer.getOffer();
        try {
            String returnAddress;
            this.runInterceptHook();
            Optional<XmrAddressEntry> addressEntryOpt = ((PlaceOfferModel)this.model).getXmrWalletService().getAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT);
            if (addressEntryOpt.isPresent()) {
                returnAddress = addressEntryOpt.get().getAddressString();
            } else {
                log.warn("Payout address entry found for unsigned offer {} is missing, creating anew", (Object)offer.getId());
                returnAddress = ((PlaceOfferModel)this.model).getXmrWalletService().getOrCreateAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString();
            }
            SignOfferRequest request = new SignOfferRequest(offer.getId(), P2PService.getMyNodeAddress(), ((PlaceOfferModel)this.model).getKeyRing().getPubKeyRing(), ((PlaceOfferModel)this.model).getUser().getAccountId(), offer.getOfferPayload(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), openOffer.getReserveTxHash(), openOffer.getReserveTxHex(), openOffer.getReserveTxKey(), offer.getOfferPayload().getReserveTxKeyImages(), returnAddress);
            this.sendSignOfferRequests(request, () -> this.complete(), errorMessage -> this.failed("Error signing offer " + request.getOfferId() + ": " + errorMessage));
        }
        catch (Throwable t) {
            offer.setErrorMessage("An error occurred.\nError message:\n" + t.getMessage());
            this.failed(t);
        }
    }

    private void sendSignOfferRequests(SignOfferRequest request, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Arbitrator randomArbitrator = DisputeAgentSelection.getRandomArbitrator(((PlaceOfferModel)this.model).getArbitratorManager());
        if (randomArbitrator == null) {
            errorMessageHandler.handleErrorMessage("Could not get random arbitrator to send " + ((Object)((Object)request)).getClass().getSimpleName() + " for offer " + request.getOfferId());
            return;
        }
        this.sendSignOfferRequests(request, randomArbitrator.getNodeAddress(), new HashSet<NodeAddress>(), resultHandler, errorMessageHandler);
    }

    private void sendSignOfferRequests(final SignOfferRequest request, final NodeAddress arbitratorNodeAddress, final Set<NodeAddress> excludedArbitrators, final ResultHandler resultHandler, final ErrorMessageHandler errorMessageHandler) {
        DecryptedDirectMessageListener ackListener = new DecryptedDirectMessageListener(){

            public void onDirectMessage(DecryptedMessageWithPubKey decryptedMessageWithPubKey, NodeAddress sender) {
                if (!(decryptedMessageWithPubKey.getNetworkEnvelope() instanceof AckMessage)) {
                    return;
                }
                if (!sender.equals((Object)arbitratorNodeAddress)) {
                    return;
                }
                AckMessage ackMessage = (AckMessage)decryptedMessageWithPubKey.getNetworkEnvelope();
                if (!ackMessage.getSourceMsgClassName().equals(SignOfferRequest.class.getSimpleName())) {
                    return;
                }
                if (!ackMessage.getSourceUid().equals(request.getUid())) {
                    return;
                }
                if (ackMessage.isSuccess()) {
                    ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getP2PService().removeDecryptedDirectMessageListener((DecryptedDirectMessageListener)this);
                    ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getOpenOffer().getOffer().getOfferPayload().setArbitratorSigner(arbitratorNodeAddress);
                    ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getOpenOffer().getOffer().setState(Offer.State.OFFER_FEE_RESERVED);
                    resultHandler.handleResult();
                } else {
                    ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getOpenOffer().getOffer().setState(Offer.State.INVALID);
                    errorMessageHandler.handleErrorMessage("Arbitrator nacked SignOfferRequest for offer " + request.getOfferId() + ": " + ackMessage.getErrorMessage());
                }
            }
        };
        ((PlaceOfferModel)this.model).getP2PService().addDecryptedDirectMessageListener(ackListener);
        this.sendSignOfferRequest(request, arbitratorNodeAddress, new SendDirectMessageListener(){

            public void onArrived() {
                log.info("{} arrived at arbitrator: offerId={}", (Object)((Object)((Object)request)).getClass().getSimpleName(), (Object)((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getOpenOffer().getId());
                ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getProtocol().startTimeoutTimer();
            }

            public void onFault(String errorMessage) {
                log.warn("Arbitrator unavailable: address={}, error={}", (Object)arbitratorNodeAddress, (Object)errorMessage);
                excludedArbitrators.add(arbitratorNodeAddress);
                if (!((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getOpenOffer().isPending()) {
                    errorMessageHandler.handleErrorMessage("Offer is no longer pending, offerId=" + ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getOpenOffer().getId());
                    return;
                }
                Arbitrator altArbitrator = DisputeAgentSelection.getRandomArbitrator(((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getArbitratorManager(), excludedArbitrators);
                if (altArbitrator == null) {
                    errorMessageHandler.handleErrorMessage("Offer " + request.getOfferId() + " could not be signed by any arbitrator");
                    return;
                }
                log.info("Using alternative arbitrator {}", (Object)altArbitrator.getNodeAddress());
                ((PlaceOfferModel)MakerSendSignOfferRequest.this.model).getProtocol().startTimeoutTimer();
                MakerSendSignOfferRequest.this.sendSignOfferRequests(request, altArbitrator.getNodeAddress(), excludedArbitrators, resultHandler, errorMessageHandler);
            }
        });
    }

    private void sendSignOfferRequest(SignOfferRequest request, NodeAddress arbitratorNodeAddress, SendDirectMessageListener listener) {
        Arbitrator arbitrator = ((PlaceOfferModel)this.model).getUser().getAcceptedArbitratorByAddress(arbitratorNodeAddress);
        if (arbitrator == null) {
            throw new RuntimeException("Node address " + String.valueOf(arbitratorNodeAddress) + " is not a registered arbitrator");
        }
        request.getOfferPayload().setArbitratorSigner(arbitratorNodeAddress);
        log.info("Sending {} with offerId {} and uid {} to arbitrator {}", new Object[]{((Object)((Object)request)).getClass().getSimpleName(), request.getOfferId(), request.getUid(), arbitratorNodeAddress});
        ((PlaceOfferModel)this.model).getP2PService().sendEncryptedDirectMessage(arbitratorNodeAddress, arbitrator.getPubKeyRing(), (NetworkEnvelope)request, listener, Integer.valueOf(60));
    }
}

